/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import ordermate.gui.dialogs.ForcedChoiceOptionDialog;

public class OfficeMateGuiHandler
implements GuiHandler {
    private JDialog blocker;

    public boolean displayForcedChoiceDialog(String title, String message, String positiveOption, String negativeOption) {
        return Dialogs.showChoiceDialog(title, message);
    }

    public void displayOkDialog(String title, String message) {
        Dialogs.showInfoDialog(title, message);
    }

    public void displayOkDialog(JComponent comp, String title) {
        OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(comp);
        builder.setTitle(title).hideCancel().doPack().doShow();
    }

    public void refreshBlockingDialog(JPanel mainComponent) {
    }

    public void closeBlockingDialog(JPanel mainComponent) {
        if (this.blocker != null) {
            this.blocker.setVisible(false);
            this.blocker = null;
        }
    }

    public void displayBlockingDialog(JPanel mainComponent) {
        if (this.blocker == null) {
            this.blocker = new JDialog(OfficeMate.getApplicationFrame());
            this.blocker.setModal(true);
        }
        this.blocker.getContentPane().removeAll();
        this.blocker.getContentPane().add(mainComponent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OfficeMateGuiHandler.this.blocker.pack();
                OfficeMateGuiHandler.this.blocker.setLocationRelativeTo(OfficeMate.getApplicationFrame());
                OfficeMateGuiHandler.this.blocker.setVisible(true);
            }
        });
    }

    public String getStringInput(String message, String initialString) {
        return JOptionPane.showInputDialog(message, (Object)initialString);
    }

    public boolean isDarkLaf() {
        return false;
    }

    public Object displayChoiceDialog(String title, String message, List<?> options, Object defaultOption) {
        Object option = Dialogs.showOptionDialog(title, message, options);
        if (option == null) {
            option = defaultOption;
        }
        return option;
    }

    public void displayErrorDialog(String title, String message, String errorDetails) {
        Dialogs.showErrorDetailDialog(title, message, errorDetails);
    }

    public ForcedChoiceOptionDialog createForcedChoiceDialog(String message, String title, String posText, String negText, List<String> options, boolean requiresConfirmation) {
        return null;
    }

    public void doProgressTask(AbstractTask task) {
        Dialogs.createProgressDialog(task).start();
    }

    public void showTextMessage(String title, String message, JFrame parentFrame) {
        final JDialog dialog = new JDialog(parentFrame, title, true);
        dialog.setSize(400, 300);
        dialog.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(message);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        dialog.add((Component)scrollPane, "Center");
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.add((Component)closeButton, "South");
        dialog.setVisible(true);
    }
}

