/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.dialogs.EditFieldDialog;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectManagerFieldPanel;
import officemate.adminkit.types.ArrayFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.components.controls.toolbar.CrudService;
import officemate.components.controls.toolbar.CrudToolBar;
import ordermate.database.users.Permission;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ArrayFieldPanel
extends ObjectManagerFieldPanel
implements CrudService {
    public final Signal elementEdited = Signals.createSignal(Object.class, (String)"element", Integer.class, (String)"index");
    public final Signal elementCreated = Signals.createSignal(Object.class, (String)"element", Integer.class, (String)"index");
    public final Signal elementRemoved = Signals.createSignal(Object.class, (String)"element", Integer.class, (String)"index");
    public final Signal allElementsRemoved = Signals.createSignal();
    private static final String SPARE_ELEMENT = "<new>";
    protected ArrayFieldType fieldType;
    protected JList list;
    protected DefaultListModel listModel;
    private CrudToolBar buttonPanel;
    private JScrollPane scroller;
    private boolean acceptsTypedEntries = false;
    private StringBuffer typedKeys = new StringBuffer();

    public ArrayFieldPanel(ObjectManager manager) {
        super(manager);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(70, 0));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
        this.buttonPanel = new CrudToolBar(this);
        InnerEventListener iel = new InnerEventListener();
        this.list.addListSelectionListener(iel);
        this.list.addMouseListener(iel);
        this.list.addKeyListener(iel);
        FieldPanel.InnerSecondaryActionListener secondaryListener = new FieldPanel.InnerSecondaryActionListener(this);
        this.buttonPanel.addActionListenerToAll(secondaryListener);
        this.add((Component)this.buttonPanel.getGuiComponent(), "South");
        this.scroller = new JScrollPane(this.list, 22, 31);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.add((Component)this.scroller, "Center");
        this.setPreferredSize(new Dimension(400, 150));
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
    }

    protected CrudToolBar getToolBar() {
        return this.buttonPanel;
    }

    public JList getJList() {
        return this.list;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    private void acceptPressedKey(char c) {
        if (this.acceptsTypedEntries) {
            if (c == '\n') {
                if (this.typedKeys.length() > 0) {
                    this.addElement(this.typedKeys.toString());
                    this.typedKeys.delete(0, this.typedKeys.length());
                }
            } else if (StringUtils.isDisplayable((char)c)) {
                this.typedKeys.append(c);
            } else {
                this.typedKeys.delete(0, this.typedKeys.length());
            }
        }
    }

    private boolean usesSpareElement() {
        return this.isArbitraryLength() || !this.isFixedLength();
    }

    private boolean isSpareElementSelected() {
        return this.usesSpareElement() && this.list.getSelectedIndex() == this.listModel.size() - 1;
    }

    public int getNumElements() {
        int size = this.listModel.size();
        return this.usesSpareElement() ? size - 1 : size;
    }

    public void addElement(Object element) {
        if (this.isFixedLength() || !this.isArbitraryLength() && this.getNumElements() == this.getArrayLength()) {
            throw new IllegalStateException("Can't add an element under these circumstances.");
        }
        if (this.usesSpareElement()) {
            this.listModel.remove(this.listModel.size() - 1);
        }
        this.listModel.addElement(element);
        if (this.usesSpareElement()) {
            this.listModel.addElement(SPARE_ELEMENT);
        }
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
        this.updateButtonStates();
        this.elementCreated.emit(element, (Object)(this.listModel.size() - 2));
    }

    @Override
    public void newElement() {
        if (!this.isFixedLength() && (this.isArbitraryLength() || this.getNumElements() < this.getArrayLength())) {
            EditFieldDialog dialog = new EditFieldDialog(this.getElementFieldPanel());
            dialog.setLocationRelativeTo(GuiApp.getAppComplex().getApplicationFrame().getFrame());
            dialog.setVisible(true);
            Object value = dialog.getValue();
            if (dialog.wasOKed() && value != null) {
                this.addElement(value);
            }
        }
    }

    @Override
    public void editSelectedElement() {
        if (this.isSpareElementSelected()) {
            this.newElement();
            return;
        }
        int selIndex = this.list.getSelectedIndex();
        if (selIndex != -1) {
            Object originalValue = this.list.getSelectedValue();
            FieldPanel newFieldPanel = this.getElementFieldPanel();
            newFieldPanel.setValue(this.listModel.getElementAt(selIndex));
            EditFieldDialog dialog = new EditFieldDialog(newFieldPanel, originalValue);
            dialog.setVisible(true);
            if (dialog.wasOKed()) {
                Object value = dialog.getValue();
                this.listModel.set(selIndex, value);
                this.elementEdited.emit(value, (Object)selIndex);
            }
            this.updateButtonStates();
        }
    }

    @Override
    public void removeSelectedElement() {
        int selIndex;
        if (!this.isSpareElementSelected() && (selIndex = this.list.getSelectedIndex()) != -1) {
            Object value = this.listModel.get(selIndex);
            this.listModel.remove(selIndex);
            if (selIndex < this.listModel.getSize()) {
                this.list.setSelectedIndex(selIndex);
            } else {
                this.list.setSelectedIndex(this.listModel.getSize() - 1);
            }
            this.elementRemoved.emit(value, (Object)selIndex);
        }
        this.updateButtonStates();
    }

    @Override
    public void removeAllElements() {
        if (this.isFixedLength()) {
            throw new IllegalStateException("Cannot remove elements of a fixed-length array");
        }
        this.listModel.clear();
        this.listModel.addElement(SPARE_ELEMENT);
        this.list.setSelectedIndex(0);
        this.updateButtonStates();
        if (this.getNumElements() != 0) {
            throw new IllegalStateException("Failed to remove all elements: " + this.getNumElements() + " remaining");
        }
        this.allElementsRemoved.emit();
    }

    @Override
    public List getValue() {
        ArrayList elements = new ArrayList();
        int numElements = this.getNumElements();
        for (int i = 0; i < numElements; ++i) {
            elements.add(this.listModel.getElementAt(i));
        }
        return elements;
    }

    @Override
    public void setValue(Object o) {
        List array = (List)o;
        if (!this.isArbitraryLength()) {
            if (this.isFixedLength() && this.getArrayLength() != array.size()) {
                throw new IllegalArgumentException("Expected array length of " + this.getArrayLength() + ", found: " + array.size());
            }
            if (!this.isFixedLength() && this.getArrayLength() < array.size()) {
                throw new IllegalArgumentException("Expected array length of no more than " + this.getArrayLength() + ", found: " + array.size());
            }
        }
        this.listModel = new DefaultListModel();
        for (int i = 0; i < array.size(); ++i) {
            this.listModel.addElement(array.get(i));
        }
        if (this.usesSpareElement()) {
            this.listModel.addElement(SPARE_ELEMENT);
        }
        this.list.setModel(this.listModel);
        this.list.setSelectedIndex(0);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean spareElementSelected = this.isSpareElementSelected();
        int listSize = this.listModel.getSize();
        if (!this.isArbitraryLength()) {
            int arrayLen = this.getArrayLength();
            if (this.isFixedLength()) {
                this.buttonPanel.setAddEnabled(false);
                this.buttonPanel.setEditEnabled(true);
                this.buttonPanel.setRemoveEnabled(false);
                this.buttonPanel.setRemoveAllEnabled(false);
            } else {
                if (listSize < 0) {
                    throw new IllegalStateException("Impossible list size: " + listSize);
                }
                this.buttonPanel.setAddEnabled(listSize < arrayLen);
                this.buttonPanel.setEditEnabled(!spareElementSelected);
                this.buttonPanel.setRemoveEnabled(!spareElementSelected);
                this.buttonPanel.setRemoveAllEnabled(this.getNumElements() > 0);
            }
        } else {
            this.buttonPanel.setAddEnabled(true);
            this.buttonPanel.setEditEnabled(!spareElementSelected);
            this.buttonPanel.setRemoveEnabled(!spareElementSelected);
            this.buttonPanel.setRemoveAllEnabled(this.getNumElements() > 0);
        }
    }

    @Override
    public void setFieldType(FieldType fType) {
        this.assignFieldType(fType);
        if (this.isFixedLength()) {
            int i;
            int arrayLength = this.getArrayLength();
            Object[] array = new Object[arrayLength];
            for (i = 0; i < array.length; ++i) {
                array[i] = this.getDefaultElementValue();
            }
            this.listModel.clear();
            for (i = 0; i < array.length; ++i) {
                this.listModel.addElement(array[i]);
            }
        } else {
            this.listModel.clear();
            this.listModel.addElement(SPARE_ELEMENT);
            if (this.getNumElements() != 0) {
                throw new IllegalStateException("Expected empty list after reset, found: " + this.getNumElements());
            }
        }
        this.list.setSelectedIndex(0);
        this.updateButtonStates();
    }

    protected boolean isFixedLength() {
        return this.fieldType.isFixedLength();
    }

    protected boolean isArbitraryLength() {
        return this.fieldType.isArbitraryLength();
    }

    protected int getArrayLength() {
        return this.fieldType.getArrayLength();
    }

    protected FieldPanel getElementFieldPanel() {
        FieldPanel panel = this.fieldType.getElementType().getPanel(this.getObjectManager());
        return panel;
    }

    protected Object getDefaultElementValue() {
        return this.fieldType.getElementType().getDefaultInitValue();
    }

    protected void assignFieldType(FieldType f) {
        this.fieldType = (ArrayFieldType)f;
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.list;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.buttonPanel.setAddEnabled(b);
        this.buttonPanel.setEditEnabled(b && this.list.getSelectedIndex() != -1);
        this.buttonPanel.setRemoveEnabled(b && this.list.getSelectedIndex() != -1);
        this.buttonPanel.setRemoveAllEnabled(b);
        this.scroller.setEnabled(b);
        this.list.setEnabled(b);
    }

    public boolean acceptsTypedEntries() {
        return this.acceptsTypedEntries;
    }

    public void setAcceptsTypedEntries(boolean b) {
        if (b && !(this.fieldType.getElementType() instanceof StringFieldType)) {
            throw new IllegalStateException("Element type must be StringFieldType to accept typed entries, found: " + this.fieldType.getElementType());
        }
        this.acceptsTypedEntries = b;
    }

    public void setPermission(Permission value) {
        this.buttonPanel.setPermission(value);
    }

    private class InnerEventListener
    extends MouseAdapter
    implements ListSelectionListener,
    KeyListener {
        private InnerEventListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ArrayFieldPanel.this.updateButtonStates();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            if (ArrayFieldPanel.this.isEnabled() && (index = ArrayFieldPanel.this.list.locationToIndex(new Point(e.getX(), e.getY()))) >= 0 && e.getButton() == 1 && e.getClickCount() == 2) {
                ArrayFieldPanel.this.editSelectedElement();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ArrayFieldPanel.this.acceptPressedKey(e.getKeyChar());
        }
    }
}

