/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.FieldType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class BoolFieldPanel
extends FieldPanel {
    public final Signal valueChanged = Signals.createSignal(Boolean.class, (String)"newValue");
    private BoolFieldType fieldType;
    private JCheckBox checkBox;
    private JComboBox comboBox;
    private JRadioButton onButton;
    private JRadioButton offButton;
    private ButtonGroup group;
    private JComponent primary;

    public BoolFieldPanel(ObjectManager manager) {
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        boolean val;
        switch (this.fieldType.getBooleanStyle()) {
            case 0: {
                val = this.checkBox.isSelected();
                break;
            }
            case 1: {
                val = this.comboBox.getSelectedIndex() == 1;
                break;
            }
            case 2: {
                val = this.group.isSelected(this.onButton.getModel());
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised BoolFieldPanel style");
            }
        }
        return val;
    }

    @Override
    public void setValue(Object o) {
        boolean val = (Boolean)o;
        switch (this.fieldType.getBooleanStyle()) {
            case 0: {
                this.checkBox.setSelected(val);
                break;
            }
            case 1: {
                this.comboBox.setSelectedIndex(val ? 1 : 0);
                break;
            }
            case 2: {
                ButtonModel on = this.onButton.getModel();
                ButtonModel off = this.offButton.getModel();
                this.group.setSelected(val ? on : off, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised BoolFieldPanel style");
            }
        }
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (BoolFieldType)fType;
        String onString = null;
        String offString = null;
        switch (this.fieldType.getBooleanOption()) {
            case 0: {
                onString = "True";
                offString = "False";
                break;
            }
            case 1: {
                onString = "Yes";
                offString = "No";
                break;
            }
            case 2: {
                onString = "On";
                offString = "Off";
                break;
            }
            case 3: {
                onString = "Enabled";
                offString = "Disabled";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised BoolFieldPanel option");
            }
        }
        if (this.checkBox != null) {
            this.remove(this.checkBox);
            this.checkBox = null;
        }
        if (this.comboBox != null) {
            this.remove(this.comboBox);
            this.comboBox = null;
        }
        if (this.group != null) {
            this.remove(this.onButton);
            this.remove(this.offButton);
            this.group = null;
            this.offButton = null;
            this.onButton = null;
        }
        InnerActionListener al = new InnerActionListener();
        switch (this.fieldType.getBooleanStyle()) {
            case 0: {
                this.checkBox = new JCheckBox();
                this.checkBox.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
                this.primary = this.checkBox;
                this.checkBox.addActionListener(al);
                this.add(this.checkBox);
                break;
            }
            case 1: {
                this.comboBox = new JComboBox<String>(new String[]{onString, offString});
                this.comboBox.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
                this.primary = this.comboBox;
                this.comboBox.addActionListener(al);
                this.add(this.comboBox);
                break;
            }
            case 2: {
                this.group = new ButtonGroup();
                this.onButton = new JRadioButton(onString);
                this.onButton.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
                this.offButton = new JRadioButton(offString);
                this.offButton.addActionListener(new FieldPanel.InnerSecondaryActionListener(this));
                this.onButton.addActionListener(al);
                this.offButton.addActionListener(al);
                this.offButton.setFocusable(false);
                this.group.add(this.onButton);
                this.group.add(this.offButton);
                this.primary = this.onButton;
                this.add(this.onButton);
                this.add(this.offButton);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised BoolFieldPanel style");
            }
        }
        this.setValue(this.fieldType.getDefaultInitValue());
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.checkBox != null) {
            this.checkBox.setEnabled(b);
        }
        if (this.comboBox != null) {
            this.comboBox.setEnabled(b);
        }
        if (this.onButton != null) {
            this.onButton.setEnabled(b);
        }
        if (this.offButton != null) {
            this.offButton.setEnabled(b);
        }
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.primary;
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BoolFieldPanel.this.valueChanged.emit(BoolFieldPanel.this.getValue());
        }
    }
}

