/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.DateTimeFieldType;
import officemate.adminkit.types.FieldType;
import org.jdesktop.swingx.JXDatePicker;

public class DateTimeFieldPanel
extends FieldPanel {
    private DateTimeFieldType fieldType;
    private JXDatePicker dateChooser;
    private JSpinner timeSpinner;

    public DateTimeFieldPanel() {
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.dateChooser = new JXDatePicker();
        this.dateChooser.setFormats(formats);
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
        this.getPrimaryComponent().addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
        Dimension size = this.dateChooser.getPreferredSize();
        size.width += 50;
        this.dateChooser.setPreferredSize(size);
        this.add((Component)this.dateChooser);
        this.add(Box.createHorizontalStrut(3));
        SpinnerDateModel sm = new SpinnerDateModel(new Date(), null, null, 12);
        this.timeSpinner = new JSpinner(sm);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.timeSpinner, "hh:mm a");
        editor.getTextField().addKeyListener(new FieldPanel.ControlKeyListener(this));
        this.timeSpinner.setEditor(editor);
        this.add(this.timeSpinner);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        return DateTimeUtils.mergeDateAndTime((Date)this.dateChooser.getDate(), (Date)((Date)this.timeSpinner.getValue()));
    }

    @Override
    public void setValue(Object o) {
        String paramClass = o != null ? o.getClass().getName() : null;
        Assert.isTrue((boolean)(o instanceof Date), (String)("Expecting java.util.Date, found " + paramClass));
        Date date = (Date)o;
        this.dateChooser.setDate(date);
        this.timeSpinner.setValue(date);
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (DateTimeFieldType)fType;
        this.setValue(this.fieldType.getDefaultInitValue());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.dateChooser;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.dateChooser.setToolTipText(text);
        this.timeSpinner.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dateChooser.setEnabled(enabled);
        this.timeSpinner.setEnabled(enabled);
    }
}

