/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import java.awt.GridLayout;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import officemate.adminkit.Enum;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.EnumFieldType;
import officemate.adminkit.types.FieldType;

public class EnumFieldPanel
extends FieldPanel {
    private EnumFieldType fieldType;
    private Enum myEnum;
    private JRadioButton[] radioButtons;
    private ButtonGroup buttonGroup;
    private Stringifier stringy = new ToStringifier();
    private JComboBox combo;
    private JComponent primary = null;

    public void setFieldType(FieldType fType) {
        this.fieldType = (EnumFieldType)fType;
        int style = this.fieldType.getStyle();
        this.stringy = this.fieldType.getStringifier() == null ? this.stringy : this.fieldType.getStringifier();
        Stringifier toolTip = this.fieldType.getToolTipStringifier();
        this.myEnum = this.fieldType.getEnum();
        int numValues = this.myEnum.getNumValues();
        if (style == 0) {
            this.combo = new JComboBox();
            this.primary = this.combo;
            Iterator i = this.myEnum.iterator();
            while (i.hasNext()) {
                this.combo.addItem(i.next());
            }
            this.add(this.combo);
        } else if (style == 1 || style == 2) {
            if (style == 1) {
                this.setLayout(new GridLayout(1, numValues));
            } else {
                this.setLayout(new GridLayout(numValues, 1));
            }
            this.radioButtons = new JRadioButton[numValues];
            this.buttonGroup = new ButtonGroup();
            Iterator i = this.myEnum.iterator();
            int count = 0;
            while (i.hasNext()) {
                Object next = i.next();
                String label = this.stringy.stringify(next);
                JRadioButton newButton = new JRadioButton(label);
                if (count == 0) {
                    this.primary = newButton;
                } else {
                    newButton.setFocusable(false);
                    newButton.addActionListener(new FieldPanel.InnerSecondaryActionListener(this));
                }
                if (toolTip != null) {
                    newButton.setToolTipText(toolTip.stringify(next));
                }
                this.buttonGroup.add(newButton);
                this.add(newButton);
                this.radioButtons[count++] = newButton;
            }
        } else {
            throw new IllegalStateException("Unrecognised enum field panel style: " + style);
        }
        this.primary.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
        this.setValue(this.fieldType.getDefaultInitValue());
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        int style = this.fieldType.getStyle();
        if (style == 0) {
            return this.combo.getSelectedItem();
        }
        if (style == 1 || style == 2) {
            for (int i = 0; i < this.radioButtons.length; ++i) {
                if (!this.radioButtons[i].isSelected()) continue;
                Iterator enumIt = this.myEnum.iterator();
                while (enumIt.hasNext()) {
                    Object enumVal = enumIt.next();
                    if (!this.stringy.stringify(enumVal).equals(this.radioButtons[i].getText())) continue;
                    return enumVal;
                }
                throw new IllegalStateException("Unrecognized selected enum value.");
            }
            return null;
        }
        throw new IllegalStateException("Unrecognised enum field panel style: " + style);
    }

    @Override
    public void setValue(Object o) {
        Object value = o;
        if (value == null) {
            value = this.myEnum.getFirst();
        }
        if (!this.myEnum.hasValue(value)) {
            throw new IllegalArgumentException("Unexpected value, enum \"" + this.fieldType.getEnum().getName() + "\" does not contain value: " + o);
        }
        int style = this.fieldType.getStyle();
        if (style == 0) {
            this.combo.setSelectedItem(value);
        } else if (style == 1 || style == 2) {
            for (int i = 0; i < this.radioButtons.length; ++i) {
                if (!this.radioButtons[i].getText().equals(this.stringy.stringify(value))) continue;
                this.radioButtons[i].setSelected(true);
            }
        } else {
            throw new IllegalStateException("Unrecognised enum field panel style: " + style);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.radioButtons != null) {
            for (int i = 0; i < this.radioButtons.length; ++i) {
                this.radioButtons[i].setEnabled(b);
            }
        }
        if (this.combo != null) {
            this.combo.setEnabled(b);
        }
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.primary;
    }
}

