/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import officemate.adminkit.fieldpanels.FieldPanelInterface;
import officemate.adminkit.types.FieldType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class FieldPanel<T extends FieldType>
extends JPanel
implements FieldPanelInterface {
    private static final int KEY_OK = 10;
    private static final int KEY_CANCEL = 27;
    public final Signal focusGained = Signals.createSignal(FieldPanel.class, (String)"thisPanel");
    public final Signal focusLost = Signals.createSignal(FieldPanel.class, (String)"thisPanel");
    public final Signal okPressed = Signals.createSignal();
    public final Signal cancelPressed = Signals.createSignal();

    public FieldPanel() {
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    public void reset() {
        this.setValue(this.getFieldType().getDefaultInitValue());
    }

    public abstract void setFieldType(T var1);

    public abstract T getFieldType();

    public abstract void setValue(Object var1);

    public abstract JComponent getPrimaryComponent();

    @Override
    public JComponent getGuiComponent() {
        return this;
    }

    @Override
    public final Signal getOkSignal() {
        return this.okPressed;
    }

    @Override
    public final Signal getCancelSignal() {
        return this.cancelPressed;
    }

    protected final class InnerSecondaryActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FieldPanel.this.getPrimaryComponent().requestFocus();
        }
    }

    protected final class InnerPrimaryFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            FieldPanel.this.focusGained.emit((Object)FieldPanel.this);
            JComponent component = FieldPanel.this.getPrimaryComponent();
            if (component instanceof JTextComponent) {
                final JTextComponent textComponent = (JTextComponent)component;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.selectAll();
                    }
                });
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            FieldPanel.this.focusLost.emit((Object)FieldPanel.this);
        }
    }

    protected final class ControlKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                FieldPanel.this.okPressed.emit();
            } else if (key == 27) {
                FieldPanel.this.cancelPressed.emit();
            }
        }
    }
}

