/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.PriceFieldType;
import ordermate.internationalization.Internationalization;

public class PriceFieldPanel
extends FieldPanel {
    private PriceFieldType fieldType;
    private JLabel dollarLabel = new JLabel(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
    private SpinnerNumberModel spinnerModel;
    private JSpinner spinner;
    private JTextField textField;

    public PriceFieldPanel(ObjectManager manager) {
        this.setLayout(new BorderLayout());
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        this.updateSpinner();
        Price retval = new Price(this.spinnerModel.getNumber().doubleValue(), 0.0);
        return retval;
    }

    public void updateSpinner() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            OrderMateLog.LOG.warn("Problem in update spinner", (Throwable)e);
            this.spinner.setValue(this.spinnerModel.getValue());
        }
    }

    @Override
    public void setValue(Object o) {
        Price defObj;
        double val = o == null ? ((defObj = this.fieldType.getDefaultValue()) != null ? defObj.doubleValue() : 0.0) : ((Price)o).doubleValue();
        Price max = this.fieldType.getMaxValue();
        Price min = this.fieldType.getMinValue();
        if (min != null && val < min.doubleValue()) {
            val = min.doubleValue();
        } else if (max != null && val > max.doubleValue()) {
            val = max.doubleValue();
        }
        this.spinner.setValue(new Price(val, 0.0));
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (PriceFieldType)fType;
        Price minObj = this.fieldType.getMinValue();
        Price maxObj = this.fieldType.getMaxValue();
        Price defObj = this.fieldType.getDefaultValue();
        double min = minObj != null ? minObj.doubleValue() : -1.0E7;
        double max = maxObj != null ? maxObj.doubleValue() : 1.0E7;
        double def = defObj != null ? defObj.doubleValue() : 0.0;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        if (this.spinner != null) {
            innerPanel.remove(this.spinner);
        }
        this.spinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.spinner = new JSpinner(this.spinnerModel);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        this.textField = editor.getTextField();
        this.textField.setColumns(20);
        this.textField.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
        this.spinner.setPreferredSize(new Dimension(70, 20));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.spinner, "East");
        northPanel.add((Component)this.dollarLabel, "West");
        innerPanel.add((Component)northPanel, "North");
        this.add((Component)innerPanel, "North");
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.dollarLabel.setEnabled(b);
        this.spinner.setEnabled(b);
        this.textField.setEnabled(b);
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

