/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.list;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ResultSetListModel
extends AbstractListModel
implements ComboBoxModel {
    private EventListenerList listDataListeners;
    private List<Long> ids;
    private List<Object> data;
    private Map<Long, Integer> idsToIndices;
    private Map<Object, Integer> objectsToIndices;
    private String idField;
    private String displayField;
    private int listSize = 0;
    private int selectedIndex = -1;

    public ResultSetListModel(String idFieldName, String displayFieldName) {
        this.idField = idFieldName;
        this.displayField = displayFieldName;
        this.listDataListeners = new EventListenerList();
    }

    public boolean storesIDs() {
        return this.idField != null;
    }

    public void setData(ResultSet rs) throws SQLException {
        this.data = new Vector<Object>();
        this.ids = new Vector<Long>();
        this.idsToIndices = new Hashtable<Long, Integer>();
        this.objectsToIndices = new Hashtable<Object, Integer>();
        this.fireIntervalRemoved(this, 0, this.listSize - 1);
        this.listSize = 0;
        while (rs.next()) {
            long id = rs.getLong(this.idField);
            if (this.storesIDs()) {
                Long idWrapper = id;
                this.ids.add(idWrapper);
                this.idsToIndices.put(idWrapper, this.listSize);
            }
            Object o = rs.getObject(this.displayField);
            this.objectsToIndices.put(o, this.listSize);
            this.data.add(o);
            ++this.listSize;
            this.selectedIndex = 0;
        }
        this.fireIntervalAdded(this, 0, this.listSize - 1);
    }

    public int getIndexForID(long id) {
        Integer index = this.idsToIndices.get(id);
        return index != null ? index : -1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int i) {
        this.selectedIndex = i;
        this.fireListDataContentsChanged(i);
    }

    public long getSelectedID() {
        return this.getIDForIndex(this.selectedIndex);
    }

    public boolean containsID(long id) {
        return this.idsToIndices.containsKey(id);
    }

    public void setSelectedID(long id) {
        Integer index = this.idsToIndices.get(id);
        if (index != null) {
            this.setSelectedIndex(index);
        }
    }

    public long getIDForIndex(int index) {
        if (index >= 0 && index < this.ids.size()) {
            return this.ids.get(index);
        }
        return 0L;
    }

    @Override
    public int getSize() {
        return this.listSize;
    }

    @Override
    public Object getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedIndex >= 0 ? this.data.get(this.selectedIndex) : null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Integer index = null;
        if (anItem != null) {
            index = this.objectsToIndices.get(anItem);
        }
        this.setSelectedIndex(index != null ? index : 0);
    }

    @Override
    public void addListDataListener(ListDataListener ldl) {
        this.listDataListeners.add(ListDataListener.class, ldl);
    }

    @Override
    public void removeListDataListener(ListDataListener ldl) {
        this.listDataListeners.remove(ListDataListener.class, ldl);
    }

    protected void fireListDataContentsChanged(int indexAt) {
        EventListener[] listeners = this.listDataListeners.getListeners(ListDataListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ListDataListener ldl = (ListDataListener)listeners[i];
            ListDataEvent e = new ListDataEvent(this, 0, indexAt, indexAt);
            ldl.contentsChanged(e);
        }
    }
}

