/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.glazedlists.ChangeableMatcherEditor;
import au.com.ordermate.glazedlists.DefaultTermPrefixMatcher;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.RangeList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.impl.matchers.OrMatcher;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Comparator;
import java.util.List;
import officemate.adminkit.navigation.BluePrintComparator;
import officemate.adminkit.navigation.PermissionMatcher;
import ordermate.gui.autosuggestor.LimitedSuggestor;

class ArchitectureSuggestor
extends LimitedSuggestor<ApplicationStateBlueprint> {
    private ApplicationBlueprintArchitecture architecture;
    private ApplicationSecurity security = GuiApp.getAppComplex().getApplicationSecurity();
    private OrMatcher<ApplicationStateBlueprint> descriptionMatcher;
    private DefaultTermPrefixMatcher<ApplicationStateBlueprint> straightMatcher;
    private DefaultTermPrefixMatcher<ApplicationStateBlueprint> prefixMatcher;
    private PermissionMatcher permissionMatcher;
    private EventList<ApplicationStateBlueprint> bluePrints;
    private SortedList<ApplicationStateBlueprint> sortedItems;
    private FilterList<ApplicationStateBlueprint> filteredItems;
    private RangeList<ApplicationStateBlueprint> rangedItems;
    private ChangeableMatcherEditor<ApplicationStateBlueprint> descriptionMatcherEditor;
    private ChangeableMatcherEditor<ApplicationStateBlueprint> permissionMatcherEditor;
    private BluePrintComparator comparator;

    ArchitectureSuggestor() {
        super(20, 1);
        this.createFilteredList();
        this.comparator = new BluePrintComparator();
        this.sortedItems = new SortedList(this.filteredItems, (Comparator)((Object)this.comparator));
        this.rangedItems = new RangeList(this.sortedItems);
        this.rangedItems.setHeadRange(0, 20);
    }

    private void createFilteredList() {
        this.straightMatcher = new DefaultTermPrefixMatcher((Stringifier)new ToStringifier());
        this.straightMatcher.configure(true, true, false);
        this.prefixMatcher = new DefaultTermPrefixMatcher((Stringifier)new ToStringifier());
        this.prefixMatcher.configure(false, true, true);
        this.descriptionMatcher = new OrMatcher(new Matcher[]{this.straightMatcher, this.prefixMatcher});
        this.descriptionMatcherEditor = new ChangeableMatcherEditor(this.descriptionMatcher);
        this.permissionMatcher = new PermissionMatcher();
        this.permissionMatcher.setApplicationNavigator(GuiApp.getAppComplex().getApplicationNavigator());
        this.permissionMatcherEditor = new ChangeableMatcherEditor((Matcher)this.permissionMatcher);
        this.bluePrints = new BasicEventList();
        EventList matchers = GlazedLists.eventListOf((Object[])new ChangeableMatcherEditor[]{this.descriptionMatcherEditor, this.permissionMatcherEditor});
        CompositeMatcherEditor composite = new CompositeMatcherEditor(matchers);
        composite.setMode(42);
        this.filteredItems = new FilterList(this.bluePrints, (MatcherEditor)composite);
    }

    public void setSuggestionCriteria(String newCriteria) {
        this.comparator.setString(newCriteria);
        this.sortedItems.setComparator((Comparator)((Object)this.comparator));
        super.setSuggestionCriteria(newCriteria);
    }

    public void setArchitecture(ApplicationBlueprintArchitecture architecture) {
        this.architecture = architecture;
        this.extractBlueprints();
    }

    protected List<ApplicationStateBlueprint> updateList(String criteria, int limitResults) {
        this.straightMatcher.setPrefixString(criteria);
        this.prefixMatcher.setPrefixString(criteria);
        this.descriptionMatcherEditor.matcherChanged();
        return this.rangedItems;
    }

    private void extractBlueprints() {
        this.bluePrints.getReadWriteLock().writeLock().lock();
        this.bluePrints.clear();
        for (String root : this.architecture.getRootBlueprintKeys()) {
            this.addAll(root);
        }
        this.bluePrints.getReadWriteLock().writeLock().unlock();
    }

    private void addAll(String root) {
        List childNames;
        ApplicationStateBlueprint bp = this.architecture.getBlueprint(root);
        if (!bp.getStateTitle().contains(".") && this.security.stateIsAccessable(bp.getKey(), this.security.getUser()) && bp.isSelfContained() || bp.getChildStateKeys().isEmpty()) {
            this.bluePrints.add((Object)bp);
        }
        if ((childNames = bp.getChildStateKeys()) != null) {
            for (String nextChild : childNames) {
                this.addAll(nextChild);
            }
        }
    }
}

