/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class FlatButtonUI
extends BasicButtonUI {
    private boolean rounded = false;
    private boolean paintText = false;

    public FlatButtonUI() {
        this(false, false);
    }

    public FlatButtonUI(boolean rounded, boolean paintText) {
        this.rounded = rounded;
        this.paintText = paintText;
    }

    @Override
    public void paint(Graphics g, JComponent button) {
        g.setColor(button.getBackground());
        if (button.isBackgroundSet() && button.isOpaque()) {
            if (this.rounded) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillRoundRect(0, 0, button.getWidth(), button.getHeight(), 10, 10);
            } else {
                g.fillRect(0, 0, button.getWidth(), button.getHeight());
            }
        }
        Icon icon = ((JButton)button).getIcon();
        if (((JButton)button).getIcon() != null) {
            g.drawImage(((ImageIcon)icon).getImage(), (button.getWidth() - icon.getIconWidth()) / 2, (button.getHeight() - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight(), null);
        }
        if (this.paintText && ((AbstractButton)button).getText() != null) {
            g.setColor(button.getForeground());
            String text = ((AbstractButton)button).getText();
            FontMetrics metrics = button.getFontMetrics(button.getFont());
            int x = (button.getBounds().width - metrics.stringWidth(text)) / 2;
            int y = button.getBounds().height - metrics.getHeight() / 2;
            g.drawString(text, x, y);
        }
    }
}

