/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import officemate.adminkit.navigation.OfficeMateTheme;

class FlatSplitPaneDivider
extends BasicSplitPaneDivider {
    private int oneTouchSize = 6;

    FlatSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        super.setBorder(new LineBorder(OfficeMateTheme.SPLIT_BORDER_COLOR, 1));
        this.setBackground(null);
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                if (FlatSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    g.setColor(this.getForeground());
                    if (FlatSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), FlatSplitPaneDivider.this.oneTouchSize);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g.drawPolygon(xs, ys, 3);
                    } else {
                        int blockSize;
                        xs[0] = xs[2] = (blockSize = Math.min(this.getWidth(), FlatSplitPaneDivider.this.oneTouchSize));
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.styleButton(b);
        return b;
    }

    private void styleButton(JButton b) {
        b.setMinimumSize(new Dimension(0, 0));
        b.setPreferredSize(new Dimension(0, 0));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setOpaque(false);
        b.setRequestFocusEnabled(false);
        b.setBackground(new Color(0, 0, 0, 0));
        b.setForeground(new Color(0, 0, 0, 0));
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                if (FlatSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (FlatSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), FlatSplitPaneDivider.this.oneTouchSize);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize;
                        ys[2] = 0;
                        ys[1] = 0;
                    } else {
                        int blockSize = Math.min(this.getWidth(), FlatSplitPaneDivider.this.oneTouchSize);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.setColor(this.getForeground());
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.styleButton(b);
        return b;
    }
}

