/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import officemate.adminkit.navigation.OfficeMateTheme;

public class FlatTreeUI
extends BasicTreeUI {
    private final ImageIcon expandIcon;
    private final ImageIcon expandedIcon;
    private static final int PADDING_X = -2;
    private static final int PADDING_Y = 5;
    private Color baseColour = OfficeMateTheme.STATE_SELECTION_BG;
    private Color lowColour = new Color(19, 23, 34);

    public FlatTreeUI() {
        this.expandIcon = IconLoader.get((String)"/officemate/images/expand.png");
        this.expandedIcon = IconLoader.get((String)"/officemate/images/expanded.png");
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (path.getPathCount() > 2) {
            g.setColor(this.lowColour);
        } else {
            g.setColor(this.baseColour);
        }
        g.fillRect(clipBounds.x, bounds.y, clipBounds.width, bounds.height);
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        if (!isLeaf && clipBounds.width > 100) {
            ImageIcon toDraw = isExpanded ? this.expandedIcon : this.expandIcon;
            int x = clipBounds.width - toDraw.getIconWidth() - 4 + -2;
            int y = bounds.y + toDraw.getIconHeight() / 2 + 5;
            g.drawImage(toDraw.getImage(), x, y, null);
        }
    }

    @Override
    protected void paintDropLine(Graphics arg0) {
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintHorizontalLine(Graphics arg0, JComponent arg1, int arg2, int arg3, int arg4) {
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }
}

