/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.print;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.net.URL;
import javax.swing.ImageIcon;
import officemate.adminkit.print.ReportPrintParams;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.stock.StockSupplier;

public abstract class AbstractTableReportPrintable
implements Printable {
    static final int NUM_BUSINESS_HEADER_LINES = 4;
    protected static final String NULL_CELL_STRING = "";
    static final String LOGO_IMAGE_NAME = "/ordermate/images/logo_2024_primary_transparent_240.png";
    protected static final int GAP = 3;
    protected Graphics g;
    protected PageFormat format;
    protected StockSupplier supplier;
    protected Font normalFont;
    protected Font colHeadFont;
    protected Font pageNumFont;
    protected Font titleFont;
    protected Font subTitleFont;
    protected int yPos;
    protected int xPos;
    protected int normalHeight;
    protected int colHeadHeight;
    protected int titleHeight;
    protected int subTitleHeight;
    protected int numPages;
    protected int rowHeight;
    protected int imageableHeight;
    protected int headerHeight;
    protected int footerHeight;
    protected int imageableWidth;
    protected boolean showLogo;
    private ReportPrintParams params;

    protected AbstractTableReportPrintable(ReportPrintParams theParams, boolean showLogo) {
        this.params = theParams;
        this.showLogo = showLogo;
    }

    protected void printBusinessHeader() {
        int rightXPos;
        boolean useSupplier = this.supplier != null;
        BusinessInfo info = BusinessInfo.getInstance();
        this.g.setFont(this.titleFont);
        this.yPos += this.titleHeight + 3;
        this.g.drawString(info.getName(), this.xPos, this.yPos);
        if (useSupplier) {
            String supplierName = this.supplier.getLabel();
            rightXPos = this.getRightAlignedX(supplierName);
            this.g.drawString(supplierName, rightXPos, this.yPos);
        }
        String[] headerLines = new String[]{info.getLocation(), info.getBusinessNumberType() + ": " + info.getAbn(), info.getAddress1() + " " + info.getAddress2(), "Ph: " + info.getPhone()};
        boolean FAX_INDEX = false;
        String[] supplierHeaderLines = null;
        if (useSupplier) {
            String accountNum = this.supplier.getAccountNumber();
            boolean showAccountNum = accountNum != null && accountNum.length() > 0;
            String faxNum = this.supplier.getFax();
            boolean showFax = faxNum != null && faxNum.length() > 0;
            String address1 = this.supplier.getAddress1();
            String address2 = this.supplier.getAddress2();
            if (address1 == null) {
                address1 = NULL_CELL_STRING;
            }
            if (address2 == null) {
                address2 = NULL_CELL_STRING;
            }
            supplierHeaderLines = new String[]{showFax ? "Fax: " + faxNum : NULL_CELL_STRING, address1 + " " + address2, "Ph: " + this.supplier.getPhone(), showAccountNum ? "Acct #: " + accountNum : NULL_CELL_STRING};
        }
        this.g.setFont(this.subTitleFont);
        for (int i = 0; i < headerLines.length; ++i) {
            this.yPos += this.subTitleHeight + 3;
            this.g.drawString(headerLines[i], this.xPos, this.yPos);
            if (!useSupplier || supplierHeaderLines == null) continue;
            Font currentFont = this.g.getFont();
            if (i == 0) {
                Font newFont = new Font(currentFont.getName(), currentFont.getStyle() | 1, currentFont.getSize());
                this.g.setFont(newFont);
            }
            rightXPos = this.getRightAlignedX((String)supplierHeaderLines[i]);
            this.g.drawString((String)supplierHeaderLines[i], rightXPos, this.yPos);
            this.g.setFont(currentFont);
        }
        this.yPos += 3;
    }

    protected void printLogo() {
        URL resource = this.getClass().getResource(LOGO_IMAGE_NAME);
        if (resource != null) {
            ImageIcon logoIcon = new ImageIcon(resource);
            Image logoImage = logoIcon.getImage();
            int imWidth = logoImage.getWidth(null);
            this.g.drawImage(logoIcon.getImage(), this.imageableWidth - imWidth, 0, null);
        }
    }

    protected void printTitle(String theTitle) {
        this.yPos += this.titleHeight + 3;
        this.g.setFont(this.titleFont);
        this.g.drawString(theTitle, this.xPos, this.yPos);
    }

    protected void printSubTitle(String theSubTitle) {
        this.yPos += this.subTitleHeight + 3;
        this.g.setFont(this.subTitleFont);
        this.g.drawString(theSubTitle, this.xPos, this.yPos);
    }

    int getRightAlignedX(String str) {
        int strWidth = this.getStringWidth(str);
        return this.imageableWidth - strWidth;
    }

    int getStringWidth(String str) {
        return this.g.getFontMetrics().stringWidth(str);
    }

    protected boolean setupVariables(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        this.format = pageFormat;
        this.imageableWidth = (int)this.format.getImageableWidth();
        this.imageableHeight = (int)this.format.getImageableHeight();
        this.g = graphics;
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.normalFont = new Font("Arial", 0, this.getFontPtSize());
        this.colHeadFont = new Font("Arial", 1, this.getFontPtSize());
        this.titleFont = new Font("Arial", 1, this.getFontPtSize() + 4);
        this.subTitleFont = new Font("Arial", 1, this.getFontPtSize() + 2);
        this.pageNumFont = new Font("Arial", 0, this.getFontPtSize() - 2);
        this.colHeadHeight = this.g.getFontMetrics(this.colHeadFont).getHeight();
        this.titleHeight = this.g.getFontMetrics(this.titleFont).getHeight();
        this.subTitleHeight = this.g.getFontMetrics(this.subTitleFont).getHeight();
        this.normalHeight = this.g.getFontMetrics(this.normalFont).getHeight();
        this.rowHeight = this.normalHeight + 3;
        this.headerHeight = this.titleHeight * 2 + 4 * (this.subTitleHeight + 3) + 24;
        this.footerHeight = 18 + this.colHeadHeight;
        this.xPos = 0;
        this.yPos = 0;
        return true;
    }

    protected void printLine() {
        this.yPos += 3;
        this.g.drawLine(0, this.yPos, this.imageableWidth, this.yPos);
        this.yPos += 3;
    }

    protected String getTitle() {
        return this.params.getTitle();
    }

    protected String getSubtitle() {
        return this.params.getSubtitle();
    }

    protected int getFontPtSize() {
        return this.params.getFontSize();
    }

    protected void printPageNumber(int pageIndex) {
        String pageNumString = "Page " + (pageIndex + 1) + " of " + this.numPages;
        this.yPos = this.imageableHeight - 3;
        this.xPos = this.imageableWidth - this.g.getFontMetrics().stringWidth(pageNumString);
        this.g.setFont(this.pageNumFont);
        this.g.drawString("Page " + (pageIndex + 1) + " of " + this.numPages, this.xPos, this.yPos);
    }
}

