/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.JTable;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.JTableReportPrintable;
import officemate.adminkit.print.JXTableReportPrintable;
import officemate.adminkit.print.ReportPrintParams;
import officemate.adminkit.print.UnknownPagesPageable;
import ordermate.OrderMate;
import ordermate.database.stock.StockSupplier;
import org.jdesktop.swingx.JXTable;

public final class Printing {
    public static void printJTableReport(JTable table, String title, String subTitle, int fontPtSize) {
        Printing.printJTableReport(table, title, subTitle, fontPtSize, null, null, true);
    }

    public static void printJTableReport(JTable table, String title, String subTitle, int fontPtSize, Object[] colTotals) {
        Printing.printJTableReport(table, title, subTitle, fontPtSize, colTotals, null, true);
    }

    public static void printJTableReport(JTable table, String title, String subTitle, int fontPtSize, Object[] colTotals, StockSupplier supplier, boolean showLogo) {
        JTableReportPrintable painter = new JTableReportPrintable(table, title, subTitle, fontPtSize, colTotals, supplier, showLogo);
        UnknownPagesPageable pageable = new UnknownPagesPageable(painter);
        Printing.doPrint(pageable, new ReportPrintParams().setTitle(title).setSubtitle(subTitle).setFontSize(fontPtSize));
    }

    public static void printJXTableReport(JXTable theTable, JComponent searchPanel, ReportPrintParams params) {
        JXTableReportPrintable painter = new JXTableReportPrintable(theTable, searchPanel, params);
        UnknownPagesPageable pageable = new UnknownPagesPageable(painter);
        Printing.doPrint(pageable, params);
    }

    private static void doPrint(UnknownPagesPageable pageable, ReportPrintParams params) {
        boolean doPrint;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(pageable);
        printerJob.setJobName(params.getTitle() + " - OrderMate");
        PageFormat oldFormat = pageable.getPageFormat(0);
        PageFormat format = printerJob.pageDialog(oldFormat);
        pageable.setPageFormat(format);
        boolean bl = doPrint = oldFormat != format;
        if (doPrint) {
            try {
                printerJob.print();
            }
            catch (PrinterException exception) {
                Dialogs.showErrorDialog("An error occurred whilst printing", "Could not print : " + printerJob.getJobName());
                OrderMate.LOG.warn("Printing error", (Throwable)exception);
            }
        }
    }

    private Printing() {
    }
}

