/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.search;

import au.com.ordermate.persistence.PersistentObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import officemate.adminkit.search.SearchPanel;

public class SearchDialog<T extends PersistentObject>
extends JDialog {
    private static JFrame parentFrame;
    private final ImageIcon OK_ICON = new ImageIcon(SearchDialog.class.getResource("/ordermate/images/button_ok.png"));
    private final ImageIcon CANCEL_ICON = new ImageIcon(SearchDialog.class.getResource("/ordermate/images/button_cancel.png"));
    private SearchPanel<T> searchPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean wasCancelled = true;

    public SearchDialog(JFrame owner, SearchPanel panel, String title) {
        super(owner == null ? parentFrame : owner, title, true);
        this.searchPanel = panel;
        this.searchPanel.valueSelected.connect((Object)this, "gotValueSelected");
        this.searchPanel.cancel.connect((Object)this, "gotCancel");
        ButtonListener buttonListener = new ButtonListener();
        this.okButton = new JButton(this.OK_ICON);
        this.okButton.setName("OK");
        this.okButton.setToolTipText("OK (Enter)");
        this.okButton.addActionListener(buttonListener);
        this.cancelButton = new JButton(this.CANCEL_ICON);
        this.cancelButton.setToolTipText("Cancel (Esc)");
        this.cancelButton.addActionListener(buttonListener);
        this.cancelButton.setName("cancel");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonPanel, "East");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.searchPanel, "Center");
        contentPane.add((Component)southPanel, "South");
        this.setSize(300, 300);
        this.setLocationRelativeTo(owner);
    }

    public static Long search(JFrame owner, SearchPanel panel, String title) {
        SearchDialog dialog = new SearchDialog(owner, panel, title);
        dialog.setVisible(true);
        Long id = panel.getSelectedID();
        if (!dialog.wasCancelled && id != null && id > 0L) {
            return id;
        }
        return null;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public T getFoundObject() {
        return (T)((PersistentObject)this.searchPanel.getSelectedObject());
    }

    public static void setParentFrame(JFrame frame) {
        parentFrame = frame;
    }

    public static JFrame getParentFrame() {
        return parentFrame;
    }

    void gotValueSelected() {
        this.wasCancelled = false;
        this.setVisible(false);
    }

    void gotCancel() {
        this.wasCancelled = true;
        this.setVisible(false);
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SearchDialog.this.okButton) {
                SearchDialog.this.wasCancelled = false;
            } else if (e.getSource() == SearchDialog.this.cancelButton) {
                SearchDialog.this.wasCancelled = true;
            }
            SearchDialog.this.setVisible(false);
        }
    }
}

