/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.search;

import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Assert;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class SearchPanel<T>
extends JPanel {
    private static DBConnectionInterface control = null;
    private static final String DEFAULT_ID_FIELD = "ID";
    private static final String DEFAULT_NAME_FIELD = "Name";
    public final Signal valueSelected = Signals.createSignal(Long.class, (String)"selectedID");
    public final Signal cancel = Signals.createSignal();
    public final Signal gotSelection = Signals.createSignal();
    private JTextField textField;
    private QueryTableModel tableModel;
    private QueryTable table;
    private SelectQuery query;
    private String idField;
    private String nameField;

    public SearchPanel() {
        this(DEFAULT_ID_FIELD, DEFAULT_NAME_FIELD);
    }

    public SearchPanel(boolean delayConstruction) {
        if (!delayConstruction) {
            this.construct(DEFAULT_ID_FIELD, DEFAULT_NAME_FIELD);
        }
    }

    public SearchPanel(String dbIDField, String dbNameField) {
        this.construct(dbIDField, dbNameField);
    }

    public static void setDatabaseControl(DBConnectionInterface dbControl) {
        control = dbControl;
    }

    protected final void construct(String dbIDField, String dbNameField) {
        this.setLayout(new BorderLayout());
        Assert.isTrue((control != null ? 1 : 0) != 0, (String)"SearchPanel.setDatabaseControl() must be called before SearchPanels can be instantiated.");
        this.idField = dbIDField;
        this.nameField = dbNameField;
        this.query = this.createQuery();
        this.tableModel = this.createTableModel(this.query, this.idField, this.nameField, control);
        this.table = new QueryTable(this.tableModel);
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.table.getTableHeader().setVisible(false);
        this.table.setMinimumSize(new Dimension(100, 100));
        this.setMinimumSize(new Dimension(100, 200));
        JPanel invisiblePanel = new JPanel();
        invisiblePanel.setVisible(false);
        this.table.getScroller().setColumnHeaderView(invisiblePanel);
        EnterListener enterListener = new EnterListener();
        this.table.addKeyListener(enterListener);
        this.table.addMouseListener(enterListener);
        this.textField = new JTextField();
        JLabel searchLabel = new JLabel("Search for: ");
        searchLabel.setLabelFor(this.textField);
        this.textField.addActionListener(enterListener);
        this.textField.addKeyListener(enterListener);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchPanel.this.refresh();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchPanel.this.refresh();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)searchLabel, "West");
        textPanel.add((Component)this.textField, "Center");
        this.add((Component)textPanel, "North");
        this.add((Component)this.table.getScroller(), "Center");
        this.refresh();
        this.textField.requestFocus();
    }

    public void refresh() {
        String text = this.textField.getText();
        this.query.clearOrderBy();
        this.query.clearHaving();
        this.query.clearWhere();
        if (text.length() > 0) {
            text = this.textField.getText();
            text = text.replaceAll("_", "\\\\_");
            text = text.replaceAll("%", "\\\\%");
            text = text.replaceAll("'", "\\\\'");
        }
        this.addWheresToQuery(this.query, text);
        int panelHeight = this.getHeight() != 0 ? this.getHeight() * 2 : this.getMinimumSize().height * 2;
        int displayAbleRows = panelHeight / this.table.getRowHeight();
        if (text.length() < 2) {
            this.query.addLimit(displayAbleRows);
        } else {
            this.query.removeLimit();
        }
        this.tableModel.update();
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public abstract T getSelectedObject(Long var1);

    protected abstract QueryTableModel createTableModel(SelectQuery var1, String var2, String var3, DBConnectionInterface var4);

    protected abstract SelectQuery createQuery();

    protected abstract void addWheresToQuery(SelectQuery var1, String var2);

    protected String getIDField() {
        return this.idField;
    }

    protected String getNameField() {
        return this.nameField;
    }

    public Long getSelectedID() {
        return this.table.getSelectedObjectID();
    }

    public T getSelectedObject() {
        return this.getSelectedObject(this.getSelectedID());
    }

    private class EnterListener
    extends KeyAdapter
    implements ActionListener,
    MouseListener {
        private EnterListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SearchPanel.this.valueSelected.emit((Object)SearchPanel.this.getSelectedID());
            } else if (e.getClickCount() == 1) {
                SearchPanel.this.gotSelection.emit();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 27) {
                SearchPanel.this.cancel.emit();
            } else if (e.getSource() == SearchPanel.this.table) {
                if (key == 10) {
                    SearchPanel.this.valueSelected.emit((Object)SearchPanel.this.getSelectedID());
                    e.consume();
                } else if (key == 9) {
                    SearchPanel.this.textField.requestFocus();
                    e.consume();
                }
            } else if (e.getSource() == SearchPanel.this.textField && (key == 38 || key == 40)) {
                SearchPanel.this.table.requestFocus();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.valueSelected.emit((Object)SearchPanel.this.getSelectedID());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

