/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.sales.Customer;

public class CustomerSearchPanel
extends AbstractAdminSearchPanel<Customer> {
    public CustomerSearchPanel() {
        super("sales_customer.ID", "", Customer.class);
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = new SelectQuery(new String[]{"sales_customer"});
        query.addSelectValue(this.getIDField());
        query.addSelectValue("title");
        query.addSelectValue("first_name");
        query.addSelectValue("last_name");
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery query, String typedText) {
        query.addWhere(SQL.isActive((String)"sales_customer"));
        query.addWhere("type = 'MEMBER'");
        if (typedText != null && !typedText.equalsIgnoreCase("")) {
            query.addWhere("CONCAT(sales_customer.First_Name, sales_customer.Last_Name) LIKE '%" + typedText + "%'");
            query.addOrderBy("(CONCAT(sales_customer.First_Name, sales_customer.Last_Name) NOT LIKE '" + typedText + "%')", true);
        }
        query.addOrderBy("first_name");
        query.addOrderBy("last_name");
    }

    @Override
    protected QueryTableModel createTableModel(SelectQuery query, String idField, String nameField, DBConnectionInterface control) {
        return new QueryTableModel(query, control, idField, new String[]{"title", "first_name", "last_name"}, new String[]{"Title", "First Name", "Last Name"});
    }
}

