/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.StringUtils;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;

public class InventoryRemoveSearchPanel
extends AbstractAdminSearchPanel<InventoryRemove> {
    private final InventoryProfile profile;

    public InventoryRemoveSearchPanel(InventoryProfile profile) {
        super(true, InventoryRemove.class);
        this.profile = profile;
        this.construct("inventory_remove.ID", "CONCAT(inventory_remove.name, ' (', inventory_item.name, ')')");
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = new SelectQuery(new String[]{"inventory_remove", "inventory_item", "inventory_group"});
        query.addSelectValue(this.getIDField());
        query.addSelectValue(this.getNameField());
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery query, String typedText) {
        query.addWhere(SQL.join((String)"inventory_remove", (String)"inventory_item"));
        query.addWhere(SQL.join((String)"inventory_item", (String)"inventory_group"));
        query.addWhere("inventory_group.fk_inventory_profile = " + this.profile.getID());
        query.addWhere(SQL.isActive((String)"inventory_remove"));
        if (!StringUtils.isEmpty((String)typedText)) {
            query.addWhere("inventory_remove.name LIKE '%" + typedText + "%'");
        }
        query.addOrderBy("inventory_remove.name", true);
        query.addOrderBy("inventory_item.name", true);
    }
}

