/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;

public class StockItemSearchPanel
extends AbstractAdminSearchPanel<StockItem> {
    private StockSupplier supplier = null;

    public StockItemSearchPanel() {
        this((StockSupplier)null);
    }

    public StockItemSearchPanel(StockSupplier forSupplier) {
        super(true, StockItem.class);
        this.supplier = forSupplier;
        super.construct("stock_item.ID", "stock_item.Name");
    }

    @Override
    protected SelectQuery createQuery() {
        String[] fields = this.supplier != null ? new String[]{"stock_item", "stock_item_suppliers"} : new String[]{"stock_item"};
        SelectQuery query = new SelectQuery(fields);
        query.addSelectValue(this.getIDField());
        query.addSelectValue(this.getNameField());
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery query, String typedText) {
        query.addWhere(SQL.isActive((String)"stock_item"));
        if (this.supplier != null) {
            query.addWhere("stock_item_suppliers.FK_stock_item = stock_item.ID");
            query.addWhere("stock_item_suppliers.FK_stock_supplier = " + this.supplier.getID());
        }
        if (typedText != null && !typedText.equalsIgnoreCase("")) {
            query.addWhere("stock_item.Name LIKE '%" + typedText + "%'");
            query.addOrderBy("(stock_item.Name NOT LIKE '" + typedText + "%')", true);
        }
        query.addOrderBy(this.getNameField());
    }
}

