/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.application.ApplicationComplex;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.guicore.favourite.FavoritesGuiHelper;
import au.com.ordermate.guicore.favourite.Favourite;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import officemate.adminkit.state.BasicOfficeMateActions;
import officemate.adminkit.state.GUIState;
import officemate.adminkit.state.RestrictedGUIState;
import ordermate.OrderMate;
import ordermate.database.config.custompermission.CustomPermissionHelper;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import org.apache.commons.collections.list.SetUniqueList;

public class BasicOfficeMateState
extends GUIState
implements RestrictedGUIState,
Favourite,
BasicOfficeMateActions {
    private boolean updateRequired = false;
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";
    private static final String HIDDEN = "HIDDEN";
    private Action searchAction = new SearchAction();
    private Action refreshAction = new BasicRefreshAction();
    private Action printAction = new PrintAction();
    private Action newAction = new NewAction();
    private Action editAction = new EditAction();
    private Action deleteAction = new DeleteAction();
    private Action saveAction = new SaveAction();
    private Action cancelAction = new CancelAction();
    private FavoritesGuiHelper favoriteData = null;
    private static final String SEARCH = "Search";
    private static final String REFRESH = "Refresh";
    private static final String PRINT = "Print";
    private static final String NEW = "New";
    private static final String EDIT = "Edit";
    private static final String DELETE = "Delete";
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private List<String> basicActionNames = Arrays.asList("Search", "Refresh", "Print", "New", "Edit", "Delete", "Save", "Cancel");
    private Permission accessPermission;
    private Map<String, Permission> itemPermissionMap;
    protected ImageIcon smallIcon = null;
    protected ImageIcon largeIcon = null;
    private static final ExecutorService executor;
    private List<Action> defaultActions = SetUniqueList.decorate(new ArrayList());
    private List<Action> stateSpecificActions = SetUniqueList.decorate(new ArrayList());

    public BasicOfficeMateState(String stateName, Permission permission, String description) {
        super(stateName);
        this.setAccessPermission(permission);
        this.setDescription(description);
        this.addAllDefaultActions();
    }

    public void addAllDefaultActions() {
        this.addAction(this.searchAction);
        this.addAction(this.printAction);
        this.addAction(this.refreshAction);
        this.addAction(this.newAction);
        this.addAction(this.editAction);
        this.addAction(this.deleteAction);
        this.addAction(this.saveAction);
        this.addAction(this.cancelAction);
    }

    public void setAccessPermission(Permission statePermission) {
        this.accessPermission = statePermission;
    }

    protected Permission getParentPermission() {
        if (this.getParentState() != null && this.getParentState() instanceof BasicOfficeMateState) {
            BasicOfficeMateState parent = (BasicOfficeMateState)this.getParentState();
            if (parent.getAccessPermission() == null) {
                return parent.getParentPermission();
            }
            return parent.getAccessPermission();
        }
        return null;
    }

    @Override
    public Permission getAccessPermission() {
        return this.accessPermission;
    }

    protected void init() {
    }

    public ImageIcon getSmallIcon() {
        if (this.smallIcon != null) {
            return this.smallIcon;
        }
        return this.hasSubStates() ? IconLoader.get((String)"/ordermate/images/orange_folder.png") : IconLoader.get((String)"/ordermate/images/doc_text.png");
    }

    public ImageIcon getLargeIcon() {
        if (this.largeIcon != null) {
            return this.largeIcon;
        }
        return this.hasSubStates() ? IconLoader.get((String)"/ordermate/images/orange_folder_large.png") : IconLoader.get((String)"/ordermate/images/doc_text_large.png");
    }

    @Override
    public String getAccessLevel() {
        User currentUser = this.getUser();
        if (currentUser == null) {
            return ENABLED;
        }
        String accessLevel = CustomPermissionHelper.getAccessLevel((GUIStateI)this, (User)currentUser);
        if (accessLevel != null) {
            return accessLevel;
        }
        accessLevel = ENABLED;
        Permission permission = this.getAccessPermission();
        accessLevel = permission != null ? currentUser.getPermissionAccessLevel(permission) : (this.hasSubStates() ? this.getMostLenientAccessLevel(this.getSubStates()) : currentUser.getPermissionAccessLevel(this.getParentPermission()));
        return accessLevel;
    }

    protected String getMostLenientAccessLevel(Collection<? extends GUIStateI> childrenStates) {
        String mostLenientChildAccess = HIDDEN;
        for (GUIStateI gUIStateI : childrenStates) {
            if (!(gUIStateI instanceof RestrictedGUIState)) continue;
            RestrictedGUIState restrictedChild = (RestrictedGUIState)gUIStateI;
            String childAccess = restrictedChild.getAccessLevel();
            if (childAccess.equals(ENABLED)) {
                mostLenientChildAccess = ENABLED;
                break;
            }
            if (!childAccess.equals(DISABLED) || !mostLenientChildAccess.equals(HIDDEN)) continue;
            mostLenientChildAccess = DISABLED;
        }
        return mostLenientChildAccess;
    }

    @Override
    public String getDescription() {
        if (this.getAccessLevel().equals(DISABLED)) {
            return "You are not permitted to access " + this.getName();
        }
        return super.getDescription();
    }

    public void chooseValidDefaultSubState() {
        if (this.hasSubStates()) {
            GUIStateI currentDefault = this.getDefaultSubState();
            if (!currentDefault.isSelectionAllowed()) {
                List<? extends GUIStateI> subStates = this.getSubStates();
                GUIStateI newDefault = null;
                for (int newIndex = 0; newIndex < this.getNumSubStates() && newDefault == null; ++newIndex) {
                    GUIStateI potentialDefaultState = subStates.get(newIndex);
                    if (potentialDefaultState == currentDefault || !potentialDefaultState.isSelectionAllowed()) continue;
                    newDefault = potentialDefaultState;
                }
                if (newDefault != null) {
                    this.setDefaultSubState(newDefault);
                }
            } else {
                this.setDefaultSubState(currentDefault);
            }
        }
    }

    public void refresh() {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SystemCurrentInfo.getInstance().needsUpdate()) {
                        PersistenceManager.getInstance().clearLocalCaches();
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Exception setting update flag", (Throwable)ex);
                }
            }
        });
    }

    public void setSmallIcon(ImageIcon icon) {
        this.smallIcon = icon;
    }

    public void setLargeIcon(ImageIcon icon) {
        this.largeIcon = icon;
    }

    protected void addAction(Action toAdd, Action precedingAction) {
        if (!this.stateSpecificActions.contains(precedingAction)) {
            throw new IllegalArgumentException("Preceding action must already be added to this state.");
        }
        for (int i = 1; i < this.stateSpecificActions.size(); ++i) {
            if (!this.stateSpecificActions.get(i - 1).equals(precedingAction)) continue;
            this.stateSpecificActions.add(i, toAdd);
            return;
        }
        this.stateSpecificActions.add(toAdd);
    }

    public List<Action> getDefaultActions() {
        return this.defaultActions;
    }

    public void addAction(Action toAdd) {
        if (toAdd == null) {
            return;
        }
        if (toAdd instanceof BasicAction && this.basicActionNames.contains(((BasicAction)toAdd).getText())) {
            this.replaceAction((BasicAction)toAdd);
        } else {
            this.stateSpecificActions.add(toAdd);
        }
    }

    private void replaceAction(BasicAction toAdd) {
        Action toReplace = null;
        for (Action action : this.defaultActions) {
            if (!(action instanceof BasicAction) || !((BasicAction)action).getText().equals(toAdd.getText())) continue;
            toReplace = action;
            break;
        }
        if (toReplace == null) {
            this.defaultActions.add((Action)toAdd);
        } else {
            int index = this.defaultActions.indexOf(toReplace);
            this.defaultActions.set(index, (Action)toAdd);
        }
    }

    private Action getDefaultAction(String actionName) {
        for (Action action : this.defaultActions) {
            if (!(action instanceof BasicAction) || !((BasicAction)action).getText().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public void removeStateSpecificAction(Action toRemove) {
        this.stateSpecificActions.remove(toRemove);
    }

    public void removeAllStateSpecificActions() {
        this.stateSpecificActions.clear();
    }

    public List<Action> getStateSpecificActions() {
        return this.stateSpecificActions;
    }

    @Override
    public Action getSearchAction() {
        return this.getDefaultAction(SEARCH);
    }

    @Override
    public Action getRefreshAction() {
        return this.getDefaultAction(REFRESH);
    }

    @Override
    public Action getPrintAction() {
        return this.getDefaultAction(PRINT);
    }

    @Override
    public Action getNewAction() {
        return this.getDefaultAction(NEW);
    }

    @Override
    public Action getEditAction() {
        return this.getDefaultAction(EDIT);
    }

    @Override
    public Action getDeleteAction() {
        return this.getDefaultAction(DELETE);
    }

    @Override
    public Action getSaveAction() {
        return this.getDefaultAction(SAVE);
    }

    @Override
    public Action getCancelAction() {
        return this.getDefaultAction(CANCEL);
    }

    public void toggleDefaultAction(Action actionToToggle, boolean isEnabled) {
        int index = this.defaultActions.indexOf(actionToToggle);
        this.defaultActions.get(index).setEnabled(isEnabled);
    }

    public boolean checkUpdate() {
        boolean retVal = this.updateRequired;
        this.updateRequired = false;
        for (GUIStateI gUIStateI : this.getSubStates()) {
            if (!(gUIStateI instanceof BasicOfficeMateState)) continue;
            retVal |= ((BasicOfficeMateState)gUIStateI).checkUpdate();
        }
        return retVal;
    }

    protected void setUpdateRequired() {
        this.updateRequired = true;
    }

    @Override
    protected void onStart() {
        if (this.favoriteData != null) {
            this.favoriteData.updateFavoritesAction();
        }
    }

    @Override
    protected void onEnd() {
    }

    @Override
    protected void onSubStateSelected(GUIStateI state) {
    }

    @Override
    public GUIStateI getActiveSubState() {
        GUIStateI theState = super.getActiveSubState();
        if (theState != null && !theState.isSelectionAllowed()) {
            this.chooseValidDefaultSubState();
            theState = super.getDefaultSubState();
        }
        return theState;
    }

    @Override
    public boolean isSelectionAllowed() {
        return ENABLED.equals(this.getAccessLevel());
    }

    public void setFavoritesData(FavoritesGuiHelper toSet) {
        this.favoriteData = toSet;
        if (this.favoriteData != null) {
            this.addAction(this.favoriteData.getFavouritesAction((Favourite)this));
        }
    }

    public FavoritesGuiHelper getFavoritesData() {
        return this.favoriteData;
    }

    @Override
    public User getUser() {
        ApplicationComplex complex = null;
        try {
            complex = GuiApp.getAppComplex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return complex != null ? complex.getApplicationSecurity().getUser() : null;
    }

    @Override
    public void doSearchAction() {
    }

    @Override
    public void doPrintAction() {
    }

    @Override
    public void doRefreshAction() {
        SwingUtilities.invokeLater(Refreshable.Helper.getRunnable((Refreshable)this));
    }

    @Override
    public void doNewAction() {
    }

    @Override
    public void doEditAction() {
    }

    @Override
    public void doDeleteAction() {
    }

    @Override
    public void doSaveAction() {
    }

    @Override
    public void doCancelAction() {
    }

    @Override
    public boolean supportsSearch() {
        return false;
    }

    @Override
    public boolean supportsRefresh() {
        return false;
    }

    @Override
    public boolean supportsPrint() {
        return false;
    }

    @Override
    public boolean supportsNew() {
        return false;
    }

    @Override
    public boolean supportsEdit() {
        return false;
    }

    @Override
    public boolean supportsDelete() {
        return false;
    }

    @Override
    public boolean supportsSave() {
        return false;
    }

    @Override
    public boolean supportsCancel() {
        return false;
    }

    protected void setItemsPermission(Map<String, Permission> itemPermissionMap) {
        this.itemPermissionMap = itemPermissionMap;
    }

    protected String getItemVisibility(String itemName) {
        if (this.itemPermissionMap != null) {
            HashMap itemVisibilityMap = new HashMap();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.addAll(this.itemPermissionMap.keySet());
            for (int i = 0; i < keyList.size(); ++i) {
                itemVisibilityMap.put(keyList.get(i), this.getUser().getPermissionAccessLevel(this.itemPermissionMap.get(keyList.get(i))));
            }
            return (String)itemVisibilityMap.get(itemName);
        }
        return DISABLED;
    }

    protected String getAllItemsVisibility(Permission allItemsPermission) {
        return this.getUser().getPermissionAccessLevel(allItemsPermission);
    }

    static {
        OrderMate.LOG.info("Creating basicOfficeMateState Executor");
        executor = Executors.newSingleThreadExecutor();
    }

    private class CancelAction
    extends BasicAction {
        public CancelAction() {
            super(BasicOfficeMateState.CANCEL, (Icon)IconLoader.get((String)"/officemate/images/cancel_new.png"), BasicOfficeMateState.CANCEL);
            this.setEnabled(BasicOfficeMateState.this.supportsCancel());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doCancelAction();
        }
    }

    private class SaveAction
    extends BasicAction {
        public SaveAction() {
            super(BasicOfficeMateState.SAVE, (Icon)IconLoader.get((String)"/officemate/images/save_new.png"), BasicOfficeMateState.SAVE);
            this.setEnabled(BasicOfficeMateState.this.supportsSave());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doSaveAction();
        }
    }

    private class DeleteAction
    extends BasicAction {
        public DeleteAction() {
            super(BasicOfficeMateState.DELETE, (Icon)IconLoader.get((String)"/officemate/images/delete_new.png"), BasicOfficeMateState.DELETE);
            this.setEnabled(BasicOfficeMateState.this.supportsDelete());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doDeleteAction();
        }
    }

    private class EditAction
    extends BasicAction {
        public EditAction() {
            super(BasicOfficeMateState.EDIT, (Icon)IconLoader.get((String)"/officemate/images/edit_new.png"), BasicOfficeMateState.EDIT);
            this.setEnabled(BasicOfficeMateState.this.supportsEdit());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doEditAction();
        }
    }

    private class NewAction
    extends BasicAction {
        public NewAction() {
            super(BasicOfficeMateState.NEW, (Icon)IconLoader.get((String)"/officemate/images/new.png"), BasicOfficeMateState.NEW);
            this.setEnabled(BasicOfficeMateState.this.supportsNew());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doNewAction();
        }
    }

    private class PrintAction
    extends BasicAction {
        private boolean addHead;
        private static final boolean DEFAULT_ADD_HEADER = true;

        public PrintAction() {
            this(true);
        }

        public PrintAction(boolean addHeader) {
            super(BasicOfficeMateState.PRINT, (Icon)IconLoader.get((String)"/officemate/images/print_new.png"), BasicOfficeMateState.PRINT);
            this.setEnabled(BasicOfficeMateState.this.supportsPrint());
            this.addHead = addHeader;
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doPrintAction();
        }
    }

    private class BasicRefreshAction
    extends RefreshAction {
        public BasicRefreshAction() {
            super(null);
            this.setEnabled(BasicOfficeMateState.this.supportsRefresh());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doRefreshAction();
        }
    }

    private class SearchAction
    extends BasicAction {
        public SearchAction() {
            super(BasicOfficeMateState.SEARCH, (Icon)IconLoader.get((String)"/officemate/images/search.png"), BasicOfficeMateState.SEARCH);
            this.setEnabled(BasicOfficeMateState.this.supportsSearch());
        }

        public void actionPerformed(ActionEvent e) {
            BasicOfficeMateState.this.doSearchAction();
        }
    }
}

