/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.favourite.Favourite;
import au.com.ordermate.guicore.task.GUIStateI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.state.BasicOfficeMateState;
import ordermate.database.users.Permission;
import ordermate.database.users.User;

public class CompositeGuiState
extends BasicOfficeMateState
implements ChangeListener {
    private final JTabbedPane tabbedPane;
    private final List<BasicOfficeMateState> tabbedSubstates = new ArrayList<BasicOfficeMateState>();
    private BasicOfficeMateState previousState;

    public CompositeGuiState(String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.setScreenPanel(this.tabbedPane);
    }

    @Override
    public String getAccessLevel() {
        Permission permission = this.getAccessPermission();
        User currentUser = this.getUser();
        String accessLevel = "HIDDEN";
        if (currentUser != null) {
            if (permission != null) {
                accessLevel = currentUser.getPermissionAccessLevel(permission);
            }
        } else {
            accessLevel = "ENABLED";
        }
        if (this.getAccessPermission() != null || accessLevel.equals("ENABLED")) {
            return accessLevel;
        }
        ArrayList<BasicOfficeMateState> allSubstates = new ArrayList<BasicOfficeMateState>(this.tabbedSubstates);
        allSubstates.addAll(this.getSubStates());
        return this.getMostLenientAccessLevel(allSubstates);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void addTabbedSubState(BasicOfficeMateState substate) {
        substate.setParentState(this);
        if (!this.tabbedSubstates.contains(substate)) {
            this.tabbedSubstates.add(substate);
        }
    }

    @Override
    protected void init() {
        if (!this.isFirstRun()) {
            return;
        }
        super.init();
        for (BasicOfficeMateState substate : this.tabbedSubstates) {
            substate.init();
            if (this.getFavoritesData() != null) {
                substate.addAction(this.getFavoritesData().getFavouritesAction((Favourite)this));
            }
            this.tabbedPane.addTab(substate.getName(), substate.getSmallIcon(), substate.getScreenPanel(), substate.getDescription());
        }
        if (this.tabbedSubstates.size() >= 1) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.tabbedPane.validate();
    }

    public List<BasicOfficeMateState> getTabbedStates() {
        return Collections.unmodifiableList(this.tabbedSubstates);
    }

    @Override
    protected void onStart() {
        BasicOfficeMateState state;
        this.init();
        int index = 0;
        for (int i = 0; i < this.tabbedSubstates.size(); ++i) {
            int tabIndex;
            BasicOfficeMateState state2 = this.tabbedSubstates.get(i);
            JComponent component = state2.getScreenPanel();
            if (state2.getAccessLevel().equals("ENABLED")) {
                tabIndex = this.tabbedPane.indexOfComponent(component);
                if (tabIndex == -1) {
                    this.tabbedPane.insertTab(state2.getName(), state2.getSmallIcon(), component, state2.getDescription(), index);
                    tabIndex = this.tabbedPane.indexOfComponent(component);
                }
                this.tabbedPane.setEnabledAt(tabIndex, true);
                continue;
            }
            if (state2.getAccessLevel().equals("DISABLED")) {
                tabIndex = this.tabbedPane.indexOfComponent(component);
                if (tabIndex == -1) {
                    this.tabbedPane.insertTab(state2.getName(), state2.getSmallIcon(), component, state2.getDescription(), index);
                    tabIndex = this.tabbedPane.indexOfComponent(component);
                }
                this.tabbedPane.setEnabledAt(tabIndex, false);
                continue;
            }
            if (!state2.getAccessLevel().equals("HIDDEN") || (tabIndex = this.tabbedPane.indexOfComponent(component)) == -1) continue;
            this.tabbedPane.remove(tabIndex);
        }
        if (this.tabbedPane.getSelectedIndex() == -1) {
            this.tabbedPane.setSelectedIndex(0);
        }
        if ((state = this.getSelectedTabState()) != null) {
            state.startState();
            this.tabbedPane.doLayout();
            this.tabbedPane.validate();
            state.onStart();
            this.previousState = state;
        }
        super.onStart();
    }

    @Override
    protected void onEnd() {
        super.onEnd();
        if (this.previousState != null) {
            this.previousState.onEnd();
        }
    }

    @Override
    public List<Action> getDefaultActions() {
        BasicOfficeMateState state = this.getSelectedTabState();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (state != null) {
            actions.addAll(state.getDefaultActions());
        }
        return actions;
    }

    @Override
    public List<Action> getStateSpecificActions() {
        BasicOfficeMateState state = this.getSelectedTabState();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (state != null) {
            actions.addAll(state.getStateSpecificActions());
        }
        return actions;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (GuiApp.getAppComplex().getApplicationFrame() != null && GuiApp.getAppComplex().getApplicationFrame().getState().getKey().equals(this.getStateKey())) {
            if (this.previousState != null && !this.previousState.equals(this.getSelectedTabState())) {
                this.previousState.onEnd();
            }
            this.previousState = this.getSelectedTabState();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiApp.getAppComplex().getApplicationFrame().setState(GuiApp.getAppComplex().getApplicationFrame().getState());
                    BasicOfficeMateState selectedState = CompositeGuiState.this.getSelectedTabState();
                    if (selectedState != null && !selectedState.starting) {
                        selectedState.onStart();
                    }
                }
            });
        }
    }

    public BasicOfficeMateState getSelectedTabState() {
        return this.getSubstate(this.tabbedPane.getSelectedComponent());
    }

    public void setSelectedTabState(GUIStateI guiState) {
        this.tabbedPane.setSelectedComponent(guiState.getScreenPanel());
    }

    private BasicOfficeMateState getSubstate(Component comp) {
        if (comp == null) {
            return null;
        }
        for (BasicOfficeMateState state : this.tabbedSubstates) {
            if (comp != state.getScreenPanel()) continue;
            return state;
        }
        return null;
    }

    @Override
    public void refresh() {
        BasicOfficeMateState selectedState = this.getSelectedTabState();
        if (selectedState != null) {
            selectedState.refresh();
        }
        super.refresh();
    }

    @Override
    public boolean hasSubState(GUIStateI state) {
        return super.hasSubState(state) || this.tabbedSubstates.contains(state);
    }

    @Override
    public GUIStateI getActiveSubState() {
        GUIStateI active = super.getActiveSubState();
        if (active == null) {
            active = this.getSelectedTabState();
        }
        return active;
    }
}

