/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;

public abstract class GUIState
implements GUIStateI {
    private final List<GUIStateI> subStates = new ArrayList<GUIStateI>();
    private GUIStateI parentState;
    private int activeState = 0;
    private int defaultState = 0;
    private final List<GUIStateI> stateChanges = new LinkedList<GUIStateI>();
    private boolean firstRun = true;
    private int index = -1;
    private GUIStateI currentSelectedState;
    private JComponent panel;
    private String name;
    private String description;
    private boolean errorRecovery = false;
    boolean starting = false;
    private String key;

    public GUIState(String stateName) {
        this.setName(stateName);
        this.panel = new JPanel();
        this.panel.add(new JLabel(this.getName()));
    }

    public GUIStateI getParentState() {
        return this.parentState;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public GUIStateI getLowestLevelActiveState() {
        GUIState activeSubState = this;
        while (activeSubState.hasSubStates()) {
            GUIStateI nextState = activeSubState.getActiveSubState();
            if (nextState == null) continue;
            activeSubState = nextState;
        }
        return activeSubState;
    }

    public List<? extends GUIStateI> getSubStates() {
        return Collections.unmodifiableList(this.subStates);
    }

    public void setDefaultSubState(GUIStateI state) {
        Assert.isTrue((boolean)this.hasSubState(state), (String)("Cannot set \"" + state + "\" as substate of \"" + this + "\"."));
        this.activeState = this.defaultState = state.getIndex();
    }

    public void resetActiveSubStates() {
        this.activeState = this.defaultState;
    }

    public GUIStateI getDefaultSubState() {
        return this.hasSubStates() ? this.subStates.get(this.defaultState) : null;
    }

    public void addSubState(GUIStateI state) {
        this.subStates.add(state);
        state.setIndex(this.subStates.size() - 1);
        state.setParentState((GUIStateI)this);
    }

    public void setParentState(GUIStateI parent) {
        this.parentState = parent;
    }

    public void removeSubState(GUIStateI stateToRemove) {
        Assert.isTrue((boolean)this.hasSubState(stateToRemove), (String)("State \"" + this + "\" cannot remove \"" + stateToRemove + "\", as it does not belong to it."));
        stateToRemove.setIndex(-1);
        if (!this.subStates.remove(stateToRemove)) {
            throw new IllegalStateException("Should have removed substate from the list of states");
        }
        stateToRemove.setParentState(null);
    }

    public GUIStateI getChildContaining(GUIStateI state) {
        for (GUIStateI parent = state.getParentState(); parent != null; parent = parent.getParentState()) {
            if (parent.getParentState() != this) continue;
            return parent;
        }
        return null;
    }

    public GUIStateI getActiveSubState() {
        if (this.subStates.size() > 0) {
            return this.subStates.size() > this.activeState && this.activeState >= 0 ? this.subStates.get(this.activeState) : this.subStates.get(0);
        }
        return null;
    }

    public final synchronized GUIStateI setActiveSubState(GUIStateI state) {
        if (this.currentSelectedState != null && !this.currentSelectedState.isExitAllowed()) {
            return null;
        }
        this.currentSelectedState = state;
        if (this.currentSelectedState != null) {
            boolean runNow = this.stateChanges.isEmpty();
            this.stateChanges.add(state);
            if (runNow) {
                while (!this.stateChanges.isEmpty()) {
                    GUIStateI toSwitch = this.stateChanges.get(0);
                    this.doChangeState(toSwitch);
                    this.stateChanges.remove(0);
                }
            }
        }
        if (state != null) {
            this.onSubStateSelected(state);
        }
        return this;
    }

    private void doChangeState(GUIStateI changeTo) {
        GUIStateI currentState = this.getActiveSubState();
        GUIStateI directSubState = changeTo;
        GUIStateI targetState = null;
        if (!this.hasSubState(changeTo)) {
            directSubState = this.getChildContaining(changeTo);
            targetState = changeTo;
        }
        OrderMateLog.LOG.info("GuiState : Screen change: " + this + " ---> " + directSubState);
        if (directSubState != null) {
            if (currentState != null) {
                currentState.endState();
            }
            directSubState.startState(targetState);
            this.activeState = directSubState.getIndex();
        }
    }

    public GUIStateI setActiveSubState(int substateIndex) {
        GUIStateI stateToSet = this.subStates.get(substateIndex);
        return this.setActiveSubState(stateToSet);
    }

    public boolean hasSubState(GUIStateI state) {
        return state.getParentState() == this || this.getSubStates().contains(state);
    }

    public boolean hasSubStates() {
        return this.getNumSubStates() > 0;
    }

    public int getNumSubStates() {
        return this.subStates.size();
    }

    public final void startState() {
        this.startState(this.getActiveSubState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startState(GUIStateI childState) {
        GUIState gUIState = this;
        synchronized (gUIState) {
            if (this.starting) {
                return;
            }
            this.starting = true;
        }
        GUIStateI previousState = this.getActiveSubState();
        try {
            this.onStart();
            this.firstRun = false;
        }
        catch (Exception ex) {
            String stateName = "unknown screen";
            if (childState != null) {
                stateName = childState.getName();
            }
            if (this.errorRecovery) {
                Dialogs.showErrorDialog("Could not recover", "OfficeMate attempted to recover from the error but was unable to.  Restart officemate as soon as possible.");
                return;
            }
            Dialogs.showErrorDialog("Error starting " + stateName, "Could not start " + stateName + " due to " + ex.getMessage() + ".  Will attempt to recover by going to previous screen.");
            OrderMate.LOG.error("Error starting " + stateName, (Throwable)ex);
            this.errorRecovery = true;
            this.startState(previousState);
            this.errorRecovery = false;
        }
        this.starting = false;
    }

    public final void endState() {
        this.onEnd();
        if (this.hasSubStates()) {
            this.getActiveSubState().endState();
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isExitAllowed() {
        return true;
    }

    public GUIStateI getCurrentSelectedState() {
        return this.currentSelectedState;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public JComponent getScreenPanel() {
        return this.panel;
    }

    public void setScreenPanel(JComponent comp) {
        this.panel = comp;
        this.panel.validate();
        this.panel.invalidate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isSelectionAllowed() {
        return true;
    }

    public void setStateKey(String value) {
        this.key = value;
    }

    public String getStateKey() {
        return this.key == null ? this.getClass().getName() : this.key;
    }

    protected abstract void onStart();

    protected abstract void onEnd();

    protected abstract void onSubStateSelected(GUIStateI var1);
}

