/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.login;

import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.util.MathsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.border.LineBorder;

public class ComboBoxDropDownButton
extends JButton {
    private BasicStroke thickLine;
    private Color strokeColor = ComponentColors.UNDERLINE_BLUE;
    private LineBorder lightBorder = new LineBorder(Color.WHITE, 2, true);
    private LineBorder darkBorder = new LineBorder(ComponentColors.UNDERLINE_BLUE, 1, true);

    public ComboBoxDropDownButton() {
        this.thickLine = new BasicStroke(2.0f, 1, 1);
        this.setBorder(new LineBorder(ComponentColors.UNDERLINE_BLUE, 2, true));
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                ComboBoxDropDownButton.this.strokeColor = Color.WHITE;
                ComboBoxDropDownButton.this.setBorder(ComboBoxDropDownButton.this.lightBorder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                ComboBoxDropDownButton.this.strokeColor = ComponentColors.UNDERLINE_BLUE;
                ComboBoxDropDownButton.this.setBorder(ComboBoxDropDownButton.this.darkBorder);
            }
        });
    }

    private void drawTick(Graphics2D g2) {
        g2.setStroke(this.thickLine);
        g2.setColor(this.strokeColor);
        int startX = MathsUtils.getPercentageOf((int)this.getWidth(), (int)30);
        int startY = MathsUtils.getPercentageOf((int)this.getHeight(), (int)40);
        int midX = MathsUtils.getPercentageOf((int)this.getWidth(), (int)50);
        int midY = MathsUtils.getPercentageOf((int)this.getHeight(), (int)70);
        int endX = MathsUtils.getPercentageOf((int)this.getWidth(), (int)70);
        int endY = startY;
        g2.drawLine(startX, startY, midX, midY);
        g2.drawLine(midX, midY, endX, endY);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawTick(g2);
    }
}

