/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.login;

import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import officemate.OfficeMate;

public class LoginButton
extends JButton {
    private Color fgColor = ComponentColors.UNDERLINE_BLUE;
    private Color highLightColor = ComponentColors.WHITE;
    private boolean highlight = false;
    private boolean mouseDown = false;
    private BasicStroke stroke;
    private LoginButtonModel buttonModel;

    public LoginButton(String text) {
        super(text);
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.stroke = new BasicStroke(2.0f);
        this.setFont(ComponentUtils.SANS_SERIF_PLAIN_16);
        this.buttonModel = new LoginButtonModel();
        this.setModel(this.buttonModel);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                LoginButton.this.processMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                LoginButton.this.procesMouseExited();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                LoginButton.this.mouseDown = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                LoginButton.this.mouseDown = false;
            }
        });
    }

    private void procesMouseExited() {
        this.highlight = false;
        this.repaint();
    }

    private void processMouseEntered() {
        this.highlight = true;
        this.repaint();
    }

    private void drawRoundedBorder(Graphics2D g2) {
        if (this.isEnabled() && (this.highlight || this.hasFocus() || this.getModel().isPressed())) {
            g2.setColor(this.highLightColor);
        } else {
            g2.setColor(this.fgColor);
        }
        g2.setStroke(this.stroke);
        if (this.mouseDown || this.getModel().isPressed()) {
            g2.drawRoundRect(1, 1, this.getWidth() - 4, this.getHeight() - 4, this.getHeight() - 4, this.getHeight() - 4);
        } else {
            g2.drawRoundRect(0, 0, this.getWidth() - 4, this.getHeight() - 4, this.getHeight() - 4, this.getHeight() - 4);
        }
    }

    public LoginButtonModel getButtonModel() {
        return this.buttonModel;
    }

    private void drawText(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics(this.getFont());
        int stringWidth = fm.stringWidth(this.getText());
        int stringHeight = fm.getAscent() + (this.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        if (this.isEnabled() && (this.highlight || this.hasFocus())) {
            g2.setColor(this.highLightColor);
        } else {
            g2.setColor(this.fgColor);
        }
        g2.drawString(this.getText(), (this.getWidth() - stringWidth) / 2, stringHeight - 2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawRoundedBorder(g2);
        this.drawText(g2);
    }

    static class LoginButtonModel
    extends DefaultButtonModel {
        private static final int BRIGHTNESS_DELAY = 5000;

        LoginButtonModel() {
        }

        @Override
        public void setPressed(boolean b) {
            super.setPressed(b);
            if (b) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                            this.setPressed(false);
                        }
                        catch (InterruptedException ie) {
                            OfficeMate.LOG.error(ie.getMessage(), (Throwable)ie);
                        }
                        finally {
                            this.setPressed(false);
                        }
                    }
                }).start();
            }
        }
    }
}

