/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.login;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.image.IconLoader;
import javax.swing.ImageIcon;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.login.LoginBackgroundPanel;
import officemate.adminkit.state.welcome.FloatingButtonFrame;
import ordermate.database.users.User;
import ordermate.gui.modify.security.UserSecurityManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.painter.Painter;

public class LoginState
extends BasicOfficeMateState {
    public final Signal<User, ?, ?, ?, ?> login = Signals.createSignal(User.class, (String)"User");
    public final Signal<?, ?, ?, ?, ?> exit = Signals.createSignal();
    private LoginBackgroundPanel loginPanel;
    private boolean firstTime = true;
    private static LoginState loginState;
    private final UserSecurityManager userManager;
    private Painter<LoginBackgroundPanel> painter = null;

    private LoginState(UserSecurityManager manager) {
        super("Log Out", null, "Log off the current user");
        this.userManager = manager;
    }

    public static void constructState(UserSecurityManager userManager) {
        if (loginState == null) {
            loginState = new LoginState(userManager);
        }
    }

    public static LoginState getInstance() {
        if (loginState == null) {
            throw new IllegalStateException("Need to call construct state prior to calling get instance");
        }
        return loginState;
    }

    @Override
    public void onStart() {
        if (this.firstTime) {
            this.loginPanel = new LoginBackgroundPanel(this.userManager.getUsers());
            this.loginPanel.setName("loginPanel");
            this.firstTime = false;
        }
        FloatingButtonFrame.showFloatingFrame(false);
        GuiApp.getAppComplex().getApplicationFrame().getMenuBar().setVisible(false);
        this.loginPanel.setVisible(true);
        this.setScreenPanel(this.loginPanel);
    }

    @Override
    public void onEnd() {
        GuiApp.getAppComplex().getApplicationFrame().getMenuBar().setVisible(true);
    }

    @Override
    public ImageIcon getSmallIcon() {
        return IconLoader.get((String)"/ordermate/images/logout_icon16.png");
    }

    @Override
    public void refresh() {
        if (this.loginPanel != null) {
            this.loginPanel.reloadUsers(this.userManager.getUsers());
        }
    }

    public void setPainter(Painter<LoginBackgroundPanel> painter) {
        this.painter = painter;
    }
}

