/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.AbstractComboSearchField;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.renderers.DisplayableListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.searchfield.IntegerRangeSearchField;
import officemate.components.search.searchfield.ObjectSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.OnlineAccountHelper;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;

public class AccountPropertySearch
extends ObjectPropertySearch {
    private EventList customerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private EventList driverList = GlazedLists.eventList((Collection)User.getAllDrivers());
    private EventList orderSourceList = GlazedLists.eventList((Collection)OnlineAccountHelper.getOnlineAccountOrderSources());
    private AccountSearcher searcher;
    private RefreshAction refresh;

    public AccountPropertySearch(AccountSearcher accSearcher, Refreshable toRefresh) {
        super(Account.class);
        this.refresh = new RefreshAction(toRefresh);
        this.searcher = accSearcher;
        this.setupComponents();
    }

    private void setupComponents() {
        DateRangeSearchField dateField = new DateRangeSearchField("Date Range:", (IRangedQuerySearchFilter)this.searcher.getDateRangeSearch(), Calendar.getInstance().getTime(), (Action)this.refresh);
        StringSearchField accountIDField = new StringSearchField("Receipt #:", (ISingleValueSearchFilter)this.searcher.getIDSearch(), (Action)this.refresh);
        IntegerRangeSearchField totalRangeField = new IntegerRangeSearchField(Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "Total:", (IRangedQuerySearchFilter<Integer>)this.searcher.getSavedTotalSearch(), (Action)this.refresh);
        MultiSelectComboSearchField usersCombo = new MultiSelectComboSearchField("Opened Users: ", null, GlazedLists.eventList((Collection)User.getUsers()), null, this.searcher.getOpenedByUser(), new JCheckBoxCellRenderer());
        MultiSelectComboSearchField closedUsersCombo = new MultiSelectComboSearchField("Closed Users: ", (Action)this.refresh, GlazedLists.eventList((Collection)User.getUsers()), null, this.searcher.getOpenedByUser(), new JCheckBoxCellRenderer());
        MultiSelectComboSearchField shiftCombo = new MultiSelectComboSearchField("Shift", (Action)this.refresh, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShiftsNames()), null, (MultiOptionSearchFilter)this.searcher.getShiftNameSearch(), new JCheckBoxCellRenderer());
        EventList unitsList = GlazedLists.eventList((Collection)FinanceUnit.getAllUnits());
        ComboSearchField unitTypeCombo = new ComboSearchField("Finance Unit:", (ISingleValueSearchFilter)this.searcher.getPaymentType(), true, (Action)this.refresh, unitsList);
        EventList accountTypeList = GlazedLists.eventList(AccountType.register.values());
        AbstractComboSearchField accountTypeCombo = new MultiSelectComboSearchField("Account Type:", (Action)this.refresh, accountTypeList, null, this.searcher.getAccountTypeListSearch(), new JCheckBoxCellRenderer()).setRenderer((ListCellRenderer)new DisplayableListCellRenderer());
        ObjectSearchField customerField = new ObjectSearchField((SingleValueQuerySearchFilter)this.searcher.getCustomerSearch(), (OfficeMateObjectSearch)new CustomerSearcherGui(this.customerCategories), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", (Action)this.refresh);
        customerField.getGuiComponent().setName("customerField");
        ComboSearchField deliveryField = new ComboSearchField("Drivers:", this.searcher.getDeliveryDriverSearch(), true, (Action)this.refresh, this.driverList);
        EventList terminalList = GlazedLists.eventList((Collection)Terminal.getAllTerminals());
        ComboSearchField terminalCombo = new ComboSearchField("Terminals:", (ISingleValueSearchFilter)this.searcher.getTerminalSearch(), true, (Action)this.refresh, terminalList);
        ComboSearchField printState = new ComboSearchField("Printed:", (ISingleValueSearchFilter)this.searcher.getReceiptPrintStateSearch(), true, (Action)this.refresh, GlazedLists.eventList(Account.ReceiptPrintState.register.values()));
        MultiSelectComboSearchField orderSourceTypeCombo = new MultiSelectComboSearchField("Order Source:", (Action)this.refresh, this.orderSourceList, null, this.searcher.getOrderSourceListSearch(), new JCheckBoxCellRenderer());
        MultiSelectComboSearchField salesLocationCombo = new MultiSelectComboSearchField("Sales Location:", (Action)this.refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter(), new JCheckBoxCellRenderer());
        this.addSearchField((SearchGuiField)dateField);
        this.addSearchField((SearchGuiField)accountIDField);
        this.addSearchField((SearchGuiField)usersCombo);
        this.addSearchField((SearchGuiField)closedUsersCombo);
        this.addSearchField((SearchGuiField)shiftCombo);
        this.addSearchField((SearchGuiField)unitTypeCombo);
        this.addSearchField((SearchGuiField)accountTypeCombo);
        this.addSearchField(totalRangeField);
        this.addSearchField(customerField);
        this.addSearchField((SearchGuiField)terminalCombo);
        this.addSearchField((SearchGuiField)printState);
        this.addSearchField((SearchGuiField)orderSourceTypeCombo);
        this.addSearchField((SearchGuiField)salesLocationCombo);
        if (PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.NumHomeDelivery) > 0) {
            this.addSearchField((SearchGuiField)deliveryField);
        }
    }

    protected ObjectQuerySearcher constructPropertySearcher() {
        return this.searcher;
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.customerCategories, CustomerCategory.getAllCategories());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.driverList, User.getAllDrivers());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.orderSourceList, OnlineAccountHelper.getOnlineAccountOrderSources());
    }
}

