/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts;

import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ordermate.OrderMate;
import ordermate.database.sales.Account;
import org.jdesktop.swingx.JXTable;

class ClosedAccountsTotalsPanel
extends JPanel
implements ListSelectionListener {
    private final JXTable table;
    private final EventList allAccounts;
    private final JLabel totalsLabel;
    private final JLabel selectedTotalsLabel;

    public ClosedAccountsTotalsPanel(EventList accounts, JXTable tableToMonitor) {
        this.setName("totalsPanel");
        this.allAccounts = accounts;
        this.table = tableToMonitor;
        this.selectedTotalsLabel = new JLabel();
        this.totalsLabel = new JLabel();
        this.setupComponents();
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void setupComponents() {
        this.selectedTotalsLabel.setName("selectedTotals");
        this.selectedTotalsLabel.setForeground(Color.BLUE);
        this.selectedTotalsLabel.setVisible(false);
        this.totalsLabel.setName("totals");
        this.totalsLabel.setForeground(Color.BLACK);
        this.setLayout(new FlowLayout(2));
        this.add(this.selectedTotalsLabel);
        this.add(this.totalsLabel);
        this.clearTotals();
        this.setBackground(Color.WHITE);
    }

    public void clearTotals() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClosedAccountsTotalsPanel.this.totalsLabel.setText("Updating... ");
            }
        });
    }

    public void updateTotals() {
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                try {
                    ClosedAccountsTotalsPanel.this.allAccounts.getReadWriteLock().readLock().lock();
                    Iterator it = ClosedAccountsTotalsPanel.this.allAccounts.iterator();
                    double tally = 0.0;
                    while (it.hasNext()) {
                        tally += ((Account)it.next()).getSavedTotal().doubleValue();
                    }
                    Price price = new Price(tally, 0.01);
                    return price;
                }
                finally {
                    ClosedAccountsTotalsPanel.this.allAccounts.getReadWriteLock().readLock().unlock();
                }
            }

            @Override
            protected void done() {
                try {
                    Price tally = (Price)this.get();
                    Price average = null;
                    int accountsSize = ClosedAccountsTotalsPanel.this.allAccounts.size();
                    if (tally != null && !tally.isZero() && accountsSize > 0) {
                        average = tally.divide(accountsSize);
                    }
                    String avgText = average != null ? " Avg: " + average + "," : "";
                    ClosedAccountsTotalsPanel.this.totalsLabel.setText(avgText + " Total: " + tally);
                    ClosedAccountsTotalsPanel.this.updateSelectedTotals();
                }
                catch (ExecutionException ex) {
                    OrderMate.LOG.warn("Error getting total", (Throwable)ex);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }.execute();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClosedAccountsTotalsPanel.this.updateSelectedTotals();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectedTotals() {
        try {
            this.allAccounts.getReadWriteLock().readLock().lock();
            Price tally = new Price(0.0, 1.0E-6);
            int[] selectedAccountRowIndex = this.table.getSelectedRows();
            if (selectedAccountRowIndex.length == 0) {
                this.selectedTotalsLabel.setVisible(false);
                this.selectedTotalsLabel.setText("");
            } else {
                for (int i = 0; i < selectedAccountRowIndex.length; ++i) {
                    int modelIndex = this.table.convertRowIndexToModel(selectedAccountRowIndex[i]);
                    if (modelIndex >= this.allAccounts.size()) continue;
                    tally = tally.add(((Account)this.allAccounts.get(modelIndex)).getSavedTotal());
                }
                this.selectedTotalsLabel.setText("Selected Total:" + new Price((Number)tally, 0.01) + ", ");
                this.selectedTotalsLabel.setVisible(true);
            }
        }
        finally {
            this.allAccounts.getReadWriteLock().readLock().unlock();
        }
    }
}

