/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts.actions;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.components.table.AbstractTableState;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.AllPermissions;
import ordermate.reports.printing.InvoiceReport;

public class DownloadTaxInvoiceAction
extends PermissibleAction {
    private final AbstractTableState<Account> refreshableState;
    private boolean guard = true;

    public DownloadTaxInvoiceAction(AbstractTableState<Account> state) {
        super("Download Tax Invoice", AllPermissions.PRINT_BILL, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Downloads a PDF copy of the account tax invoice", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        this.refreshableState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        AbstractTableState<Account> abstractTableState = this.refreshableState;
        synchronized (abstractTableState) {
            boolean isEnabled = this.isEnabled();
            this.setEnabled(false);
            if (this.guard && isEnabled) {
                this.guard = false;
                this.createAndDownloadPdfTaxInvoice();
            }
            this.guard = true;
        }
    }

    private void createAndDownloadPdfTaxInvoice() {
        List<Account> selectedAccounts = this.refreshableState.getCentralArea().getAllSelectedObjects();
        ArrayList<Account> failedAccounts = new ArrayList<Account>();
        ArrayList<String> createdPaths = new ArrayList<String>();
        for (Account account : selectedAccounts) {
            try {
                String businessNameNoSpaces = BusinessInfo.getInstance().getName().replace(' ', '_');
                String fileName = String.format("C:\\Temp\\%s-Tax_Invoice-%s.pdf", businessNameNoSpaces, account.getID());
                InvoiceReport invoiceReport = new InvoiceReport((ItemGroup)account, "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
                invoiceReport.generate();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("PDF documents", "pdf"));
                fileChooser.setSelectedFile(new File(fileName));
                fileChooser.setDialogTitle("Save: Tax Invoice " + account.getID().toString());
                int result = fileChooser.showSaveDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
                if (result != 0) {
                    failedAccounts.add(account);
                    continue;
                }
                fileName = fileChooser.getSelectedFile().getAbsolutePath();
                if (!fileName.endsWith(".pdf") && !fileName.endsWith(".PDF")) {
                    fileName = fileName + ".pdf";
                }
                JasperPrintManager.printReportToPdfFile((JasperPrint)invoiceReport.getReport(), (String)fileName);
                createdPaths.add(fileName);
            }
            catch (JRException ex) {
                OrderMate.LOG.error("Failed to generate InvoiceReport or print InvoiceReport to PDF for Account " + account.getID(), (Throwable)ex);
                failedAccounts.add(account);
            }
        }
        Dialogs.showMessageDialog("Tax invoice download complete!", this.createCompletionString(createdPaths, failedAccounts));
    }

    private String createCompletionString(List<String> createdPaths, List<Account> failedAccounts) {
        StringBuilder messageBuilder = new StringBuilder();
        if (!createdPaths.isEmpty()) {
            messageBuilder.append("Successfully downloaded tax invoices for the following accounts:\n");
            for (String path : createdPaths) {
                messageBuilder.append("\t- ").append(path).append("\n");
            }
            messageBuilder.append("\n");
        }
        if (!failedAccounts.isEmpty()) {
            messageBuilder.append("Failed to download tax invoices for the following accounts:\n");
            for (Account account : failedAccounts) {
                messageBuilder.append("\t- ").append(account.getID()).append("\n");
            }
        }
        return messageBuilder.toString();
    }
}

