/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.StateBuildCondition;
import au.com.ordermate.application.StateType;
import au.com.ordermate.guicore.task.GUIStateI;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import ordermate.OrderMate;
import ordermate.database.users.Permission;

public class OfficeMateBlueprint
implements ApplicationStateBlueprint {
    private Class<? extends GUIStateI> stateClazz;
    private String key;
    private StateType stateType;
    private List<StateBuildCondition> stateConditions;
    private Permission statePermission;
    private String parentStateKey;
    private List<String> childStateKeys;
    private Constructor stateClazzConstructor;
    private String stateTitle;
    private String stateTooltip;
    private ImageIcon stateIcon;
    private String favoriteStateKey;
    private List<Object> extraParams;
    private String bpDescription;
    private String bpParentTitle;

    public <T extends GUIStateI> OfficeMateBlueprint(Class<T> toBuild, String stateName) {
        this(toBuild, null, stateName);
    }

    public <T extends GUIStateI> OfficeMateBlueprint(Class<T> toBuild, Constructor<T> toBuildsConstructor, String stateName) {
        this.stateClazz = toBuild;
        this.stateClazzConstructor = toBuildsConstructor;
        if (this.stateClazz == null) {
            throw new NullPointerException("Class toBuild cannot be null!");
        }
        this.stateType = StateType.SUB_STATE;
        this.childStateKeys = new ArrayList<String>();
        this.extraParams = new ArrayList<Object>();
        this.stateTitle = stateName;
        this.key = stateName;
    }

    public ApplicationStateBlueprint setStateType(StateType toSet) {
        this.stateType = toSet;
        return this;
    }

    public ApplicationStateBlueprint addConditions(StateBuildCondition ... toAdd) {
        if (this.stateConditions == null) {
            this.stateConditions = new ArrayList<StateBuildCondition>();
        }
        Collections.addAll(this.stateConditions, toAdd);
        return this;
    }

    public ApplicationStateBlueprint setStatePermission(Permission perm) {
        this.statePermission = perm;
        return this;
    }

    public ApplicationStateBlueprint addChildStateKeys(String ... toAdd) {
        Collections.addAll(this.childStateKeys, toAdd);
        return this;
    }

    public ApplicationStateBlueprint removeChildStateKeys(String ... toAdd) {
        this.childStateKeys.removeAll(Arrays.asList(toAdd));
        return this;
    }

    public ApplicationStateBlueprint setParentStateKey(String parentKey) {
        this.parentStateKey = parentKey;
        return this;
    }

    public ApplicationStateBlueprint setStateTitle(String stateTitle) {
        this.stateTitle = stateTitle;
        this.bpDescription = null;
        return this;
    }

    public ApplicationStateBlueprint setStateTooltip(String stateTooltip) {
        this.stateTooltip = stateTooltip;
        return this;
    }

    public ApplicationStateBlueprint setConstructor(Constructor constr) {
        this.stateClazzConstructor = constr;
        return this;
    }

    public ApplicationStateBlueprint addExtraParams(Object ... toAdd) {
        Collections.addAll(this.extraParams, toAdd);
        return this;
    }

    public ApplicationStateBlueprint setStateIcon(ImageIcon toSet) {
        this.stateIcon = toSet;
        return this;
    }

    public void setFavoriteStateKey(String key) {
        this.favoriteStateKey = key;
    }

    public boolean isFavoriteState() {
        return this.favoriteStateKey != null;
    }

    public String getFavoriteStateKey() {
        return this.favoriteStateKey;
    }

    public Class<? extends GUIStateI> getStateClazz() {
        return this.stateClazz;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public List<StateBuildCondition> getStateConditions() {
        if (this.stateConditions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.stateConditions);
    }

    public Permission getStatePermission() {
        return this.statePermission;
    }

    public List<String> getChildStateKeys() {
        return this.childStateKeys;
    }

    public String getParentStateKey() {
        return this.parentStateKey;
    }

    public Constructor getStateClazzConstructor() {
        if (this.stateClazzConstructor == null) {
            this.stateClazzConstructor = this.getDefaultConstructor();
        }
        return this.stateClazzConstructor;
    }

    public String getStateTitle() {
        return this.stateTitle;
    }

    public String getStateTooltip() {
        return this.stateTooltip;
    }

    public List<Object> getExtraParams() {
        return this.extraParams;
    }

    public ImageIcon getStateIcon() {
        return this.stateIcon;
    }

    private <T extends BasicOfficeMateState> Constructor<T> getDefaultConstructor() throws IllegalStateException {
        Constructor<?>[] toConstruct = null;
        try {
            for (Constructor<?> constructor : toConstruct = this.getStateClazz().getConstructors()) {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes.length == 0) {
                    return constructor;
                }
                if (paramTypes.length == 1 && ApplicationContext.class.isAssignableFrom(paramTypes[0])) {
                    return constructor;
                }
                if (paramTypes.length != 1 || !Permission.class.isAssignableFrom(paramTypes[0])) continue;
                return constructor;
            }
        }
        catch (SecurityException e) {
            OrderMate.LOG.error("SecurityException - protected default constructor ", (Throwable)e);
        }
        throw new IllegalStateException("Constructors are all protected or unknown type!");
    }

    public void setParentTitle(String value) {
        this.bpParentTitle = value;
        this.bpDescription = null;
    }

    public String getDescription() {
        if (this.bpDescription == null) {
            StringBuilder SB = new StringBuilder();
            if (this.bpParentTitle != null) {
                SB.append(this.bpParentTitle).append(" - ");
            }
            SB.append(this.getStateTitle());
            this.bpDescription = SB.toString();
        }
        return this.bpDescription;
    }

    public String toString() {
        return this.getDescription();
    }

    public String getKey() {
        return this.key;
    }

    public ApplicationStateBlueprint setKey(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        this.key = value;
        return this;
    }

    public boolean isSelfContained() {
        return CompositeGuiState.class.isAssignableFrom(this.stateClazz);
    }
}

