/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.guicore.task.GUIStateI;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprint;
import officemate.screens.reports.jasper.JasperReportState;
import ordermate.OrderMate;
import ordermate.database.users.Permission;

public class OfficeMateBlueprintArchitecture
implements ApplicationBlueprintArchitecture<OfficeMateBlueprint> {
    private int index = 1;
    private Map<String, OfficeMateBlueprint> blueprintStructure = new HashMap<String, OfficeMateBlueprint>();
    private List<String> topLevelBlueprintsNames = new ArrayList<String>();
    boolean createFavorites = false;

    public <P extends GUIStateI, C extends GUIStateI> OfficeMateBlueprint addBlueprint(Class<C> stateClazz, Class<P> parentClass) {
        String parentName = null;
        if (parentClass != null) {
            parentName = parentClass.getName();
        }
        return this.addBlueprint(stateClazz.getName(), (Class)stateClazz, parentName);
    }

    public <C extends GUIStateI> OfficeMateBlueprint addBlueprint(Class<C> stateClazzToCreate, String parentClassName) {
        return this.addBlueprint(stateClazzToCreate.getName(), (Class)stateClazzToCreate, parentClassName);
    }

    public <C extends GUIStateI> OfficeMateBlueprint addBlueprint(String key, Class<C> stateClazzToCreate, String parentKey) {
        OfficeMateBlueprint newBlue = new OfficeMateBlueprint(stateClazzToCreate, key);
        if (this.blueprintStructure.containsKey(newBlue.getKey())) {
            StringBuilder SB = new StringBuilder(parentKey);
            SB.append(":").append(newBlue.getKey()).append(":").append(this.index);
            ++this.index;
            newBlue.setKey(SB.toString());
            if (this.blueprintStructure.containsKey(newBlue.getKey())) {
                throw new IllegalStateException("Cannot have duplicate keys for our states! Blueprint key already exists: " + newBlue.getKey());
            }
        }
        this.blueprintStructure.put(newBlue.getKey(), newBlue);
        OfficeMateBlueprint parentBlueprint = this.blueprintStructure.get(parentKey);
        if (parentBlueprint != null) {
            parentBlueprint.addChildStateKeys(newBlue.getKey());
            newBlue.setParentStateKey(parentKey);
            newBlue.setParentTitle(parentBlueprint.getStateTitle());
        } else {
            if (parentKey != null) {
                throw new IllegalStateException("Ensure that " + parentKey + " is already added to the Architecture before the child " + stateClazzToCreate.getName());
            }
            this.topLevelBlueprintsNames.add(newBlue.getKey());
        }
        this.performAutoAddedParams(newBlue.getKey(), newBlue);
        return newBlue;
    }

    private void performAutoAddedParams(String key, OfficeMateBlueprint newBlue) {
        if (this.createFavorites) {
            newBlue.setFavoriteStateKey(key);
        }
    }

    public OfficeMateBlueprint addBranch(String name, String parentName) {
        Constructor<BasicOfficeMateState> constr = this.getConstructor(BasicOfficeMateState.class, String.class, Permission.class, String.class);
        if (constr == null) {
            throw new IllegalStateException("Could not find BasicOfficeMateState's expected constructor");
        }
        return (OfficeMateBlueprint)this.addBlueprint(name, BasicOfficeMateState.class, parentName).setConstructor(constr);
    }

    public OfficeMateBlueprint addCompositeState(String name, String parentName) {
        Constructor<CompositeGuiState> constr = this.getConstructor(CompositeGuiState.class, String.class, Permission.class, String.class);
        if (constr == null) {
            throw new IllegalStateException("Could not find CompositeGuiStates expected constructor");
        }
        return (OfficeMateBlueprint)this.addBlueprint(name, CompositeGuiState.class, parentName).setConstructor(constr);
    }

    public OfficeMateBlueprint addJasperReport(String name, String parentName) {
        return this.addBlueprint(name, JasperReportState.class, parentName);
    }

    public List<OfficeMateBlueprint> getRootElements() {
        ArrayList<OfficeMateBlueprint> toReturn = new ArrayList<OfficeMateBlueprint>();
        for (String rootKey : this.getRootBlueprintKeys()) {
            toReturn.add(this.getBlueprint(rootKey));
        }
        return toReturn;
    }

    public List<String> getRootBlueprintKeys() {
        return Collections.unmodifiableList(this.topLevelBlueprintsNames);
    }

    public OfficeMateBlueprint getBlueprint(String keyOfBlueprint) {
        return this.blueprintStructure.get(keyOfBlueprint);
    }

    private <T extends BasicOfficeMateState> Constructor<T> getConstructor(Class<T> toGetConstructorOf, Class ... params) {
        Constructor<T> constr = null;
        try {
            constr = toGetConstructorOf.getConstructor(params);
        }
        catch (Exception e) {
            OrderMate.LOG.error("BasicOfficeMateState's constructor changed!!", (Throwable)e);
        }
        return constr;
    }

    public void setCreateFavorites(boolean toSet) {
        this.createFavorites = toSet;
    }

    public Set<String> getAllKeys() {
        return this.blueprintStructure.keySet();
    }
}

