/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.permission;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.FontManagerUtil;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.users.permission.PermissionAccessSelector;
import officemate.adminkit.state.users.permission.PermissionCategoryAccessSelector;
import officemate.adminkit.state.users.permission.PermissionTreePanel;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.OMApplication;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class SetupPermissionsPanel
extends JPanel {
    public final Signal accessLevelSelected = Signals.createSignal(PermissionGroup.class, (String)"permissionGroup", Permission.class, (String)"permission", String.class, (String)"accessLevel");
    private static final Font CATEGORY_FONT = FontManagerUtil.getCurrentFont().deriveFont(1, 16.0f);
    private static final Color CATEGORY_FOREGROUND = Color.black;
    private JComboBox permissionGroupCombo;
    private JPanel permissionsPanel;
    private Map categorySelectors;
    private Map permissionSelectors;
    private List categorisedPermissionLists;
    private Map<OMApplication, Set<Permission>> applicationPermissions;

    public SetupPermissionsPanel(Map<OMApplication, Set<Permission>> appPermissions, List<PermissionGroup> groups) {
        this.setLayout(new BorderLayout());
        this.applicationPermissions = appPermissions;
        ArrayList<PermissionGroup> preloadedGroups = new ArrayList<PermissionGroup>();
        User currentUser = LoginState.getInstance().getUser();
        groups.clear();
        groups.addAll(this.getAuthorizedPermissionGroups(currentUser));
        for (PermissionGroup group : groups) {
            preloadedGroups.add(this.preload(group));
        }
        this.permissionGroupCombo = new JComboBox<Object>(preloadedGroups.toArray());
        this.permissionGroupCombo.addActionListener(new ComboListener());
        this.permissionGroupCombo.setPreferredSize(new Dimension(120, 20));
        this.permissionGroupCombo.setName("Permission Group Combo");
        ComponentUtils.setupComboBox((JComboBox)this.permissionGroupCombo);
        this.categorisedPermissionLists = new ArrayList();
        this.permissionSelectors = new HashMap();
        this.categorySelectors = new HashMap();
        this.permissionsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        JPanel permissionWrapperPanel = new JPanel(new BorderLayout());
        permissionWrapperPanel.add((Component)this.permissionsPanel, "West");
        permissionWrapperPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane scroller = new JScrollPane(permissionWrapperPanel, 20, 31);
        scroller.getVerticalScrollBar().setUnitIncrement(20);
        JPanel northWestPanel = new JPanel(new FlowLayout());
        northWestPanel.add(this.permissionGroupCombo);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)northWestPanel, "West");
        PermissionTreePanel tree = new PermissionTreePanel(appPermissions);
        tree.gotPermissionApp.connect((Object)this, "applicationSelected");
        this.add((Component)tree, "West");
        this.add((Component)northPanel, "North");
        this.add((Component)scroller, "Center");
        this.applicationSelected(this.applicationPermissions.keySet().iterator().next());
    }

    public void applicationSelected(OMApplication theApp) {
        boolean firstTime = true;
        this.categorySelectors = new LinkedHashMap();
        this.permissionsPanel.removeAll();
        Set<Permission> allPermissions = this.applicationPermissions.get(theApp);
        PermissionGroup group = this.getSelectedPermissionGroup();
        if (group == null) {
            return;
        }
        List permissions = group.getPermissions(allPermissions);
        this.categorisedPermissionLists = this.categorisePermissions(permissions);
        for (Map.Entry entry : this.categorisedPermissionLists) {
            String category = (String)entry.getKey();
            List permissionList = (List)entry.getValue();
            PermissionCategoryAccessSelector categorySelector = new PermissionCategoryAccessSelector(category, permissionList);
            this.categorySelectors.put(category, categorySelector);
            categorySelector.accessLevelSelected.connect((Object)this, "gotCategoryAccessLevel");
            JPanel categorySelectorWrapper = new JPanel(new BorderLayout());
            categorySelectorWrapper.add((Component)categorySelector, "West");
            JLabel catLabel = new JLabel(category);
            catLabel.setFont(CATEGORY_FONT);
            catLabel.setForeground(CATEGORY_FOREGROUND);
            if (!firstTime) {
                this.permissionsPanel.add(new JPanel());
                this.permissionsPanel.add(new JPanel());
            }
            firstTime = false;
            JPanel categoryIconHeadingPanel = new JPanel();
            categoryIconHeadingPanel.setLayout(new GridLayout(1, 3));
            categoryIconHeadingPanel.add(new JLabel(IconLoader.get((String)"/ordermate/images/small_yes16.png"), 2));
            categoryIconHeadingPanel.add(new JLabel(IconLoader.get((String)"/ordermate/images/disabled.png"), 2));
            categoryIconHeadingPanel.add(new JLabel(IconLoader.get((String)"/ordermate/images/hidden.png"), 2));
            categoryIconHeadingPanel.setSize(260, 20);
            categoryIconHeadingPanel.setBorder(new EmptyBorder(0, 3, 0, 0));
            this.permissionsPanel.add(catLabel);
            this.permissionsPanel.add(categorySelectorWrapper);
            this.permissionsPanel.add(new JPanel());
            this.permissionsPanel.add(categoryIconHeadingPanel);
            for (Permission permission : permissionList) {
                PermissionAccessSelector permissionSelector = new PermissionAccessSelector(permission, (int)categoryIconHeadingPanel.getSize().getWidth(), 30);
                permissionSelector.accessLevelSelected.connect((Object)this, "gotPermissionAccessLevel");
                this.permissionSelectors.put(permission, permissionSelector);
                JPanel permissionSelectorWrapper = new JPanel(new BorderLayout());
                permissionSelectorWrapper.add((Component)permissionSelector, "West");
                JLabel permLabel = new JLabel(permission.getName());
                permLabel.setToolTipText(permission.getDescription());
                permLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                this.filterComponents(permLabel, permissionSelector);
                this.permissionsPanel.add(permLabel);
                this.permissionsPanel.add(permissionSelectorWrapper);
            }
            this.filterComponents(catLabel, categorySelector);
        }
        if (allPermissions.size() < 10) {
            for (int i = 0; i < 10; ++i) {
                this.permissionsPanel.add(new JPanel());
                this.permissionsPanel.add(new JPanel());
            }
        }
        this.refresh();
    }

    private void filterComponents(JLabel label, PermissionAccessSelector selector) {
        Permission permission = selector.getPermission();
        if (permission.getName().equals("Training Mode") && !SystemProperty.getInstance().isTrainingModeEnabled()) {
            selector.setVisible(false);
            if (label != null) {
                label.setVisible(false);
            }
        }
    }

    private void filterComponents(JLabel label, PermissionCategoryAccessSelector selector) {
    }

    public PermissionGroup getSelectedPermissionGroup() {
        return (PermissionGroup)this.permissionGroupCombo.getSelectedItem();
    }

    void gotPermissionAccessLevel(Permission permission, String accessLevel) {
        OrderMate.LOG.info("gotPermissionAccessLevel : " + permission + " " + accessLevel);
        PermissionGroup group = this.getSelectedPermissionGroup();
        this.updateCategoryAccessLevel(permission.getCategory());
        this.accessLevelSelected.emit((Object)group, (Object)permission, (Object)accessLevel);
    }

    void gotCategoryAccessLevel(List permissions, String accessLevel) {
        PermissionGroup group = this.getSelectedPermissionGroup();
        OrderMate.LOG.info("gotCategoryAccessLevel : " + accessLevel);
        if (accessLevel != null) {
            for (Permission p : permissions) {
                PermissionAccessSelector selector = (PermissionAccessSelector)this.permissionSelectors.get(p);
                selector.setAccessLevel(accessLevel);
                this.accessLevelSelected.emit((Object)group, (Object)p, (Object)accessLevel);
            }
        }
    }

    private void updateCategoryAccessLevel(String category) {
        List permissionsForCategory = null;
        for (Map.Entry entry : this.categorisedPermissionLists) {
            if (!entry.getKey().equals(category)) continue;
            permissionsForCategory = (List)entry.getValue();
            break;
        }
        if (permissionsForCategory != null) {
            boolean allTheSame = true;
            String accessLevel = null;
            for (Permission p : permissionsForCategory) {
                PermissionAccessSelector selector = (PermissionAccessSelector)this.permissionSelectors.get(p);
                String thisAccessLevel = selector.getAccessLevel();
                if (accessLevel != null && !accessLevel.equals(thisAccessLevel)) {
                    allTheSame = false;
                    break;
                }
                if (accessLevel != null) continue;
                accessLevel = thisAccessLevel;
            }
            PermissionCategoryAccessSelector categorySelector = (PermissionCategoryAccessSelector)this.categorySelectors.get(category);
            categorySelector.setAccessLevel(allTheSame ? accessLevel : null);
        }
    }

    void applyPermissionGroup(PermissionGroup group) {
        if (!group.equals((Object)this.getSelectedPermissionGroup())) {
            this.permissionGroupCombo.setSelectedItem(group);
        }
        OrderMate.LOG.info("Applying permission group " + group);
        group = this.preload(group);
        List permissionLinks = group.getPermissionLinks();
        if (permissionLinks.isEmpty()) {
            throw new IllegalStateException("Permission group : " + group + " has no permission links");
        }
        for (PermissionGroupLink link : permissionLinks) {
            Permission perm = link.getPermission();
            PermissionAccessSelector widget = (PermissionAccessSelector)this.permissionSelectors.get(perm);
            if (widget == null) continue;
            widget.setAccessLevel(link.getAccessLevel());
            this.filterComponents(null, widget);
        }
        for (Map.Entry entry : this.categorisedPermissionLists) {
            String category = (String)entry.getKey();
            this.updateCategoryAccessLevel(category);
        }
    }

    public void refresh() {
        this.applyPermissionGroup(this.getSelectedPermissionGroup());
        this.permissionGroupCombo.requestFocus();
        this.revalidate();
        this.repaint();
    }

    private PermissionGroup preload(PermissionGroup toPreload) {
        ArrayList<PropertiedObject.Property[]> paths = new ArrayList<PropertiedObject.Property[]>();
        paths.add(new PropertiedObject.Property[]{PermissionGroup.Properties.PERMISSION_LINKS, PermissionGroupLink.Properties.PERMISSION});
        PermissionGroup group = (PermissionGroup)PersistenceManager.preload((PersistentObject)toPreload, paths);
        return group;
    }

    private List categorisePermissions(List permissions) {
        LinkedHashMap<String, ArrayList<Permission>> permissionListsByCategory = new LinkedHashMap<String, ArrayList<Permission>>();
        User currentUser = LoginState.getInstance().getUser();
        int userLevel = currentUser.getPermissionGroup().getLevel();
        boolean isGold = false;
        if (userLevel == 9) {
            isGold = true;
        }
        for (Permission p : permissions) {
            String category = p.getCategory();
            if (!isGold && category.equals(Permission.godOnly_Category)) continue;
            ArrayList<Permission> permissionList = (ArrayList<Permission>)permissionListsByCategory.get(category);
            if (permissionList == null) {
                permissionList = new ArrayList<Permission>();
                permissionList.add(p);
                permissionListsByCategory.put(category, permissionList);
                continue;
            }
            permissionList.add(p);
        }
        return new ArrayList(permissionListsByCategory.entrySet());
    }

    private List<PermissionGroup> getAuthorizedPermissionGroups(User user) {
        ArrayList<PermissionGroup> authGroups = null;
        ArrayList<PermissionGroup> allGroups = PermissionGroup.getUniquePermissionGroups();
        if (user.isSystemAdministrator()) {
            authGroups = allGroups;
        } else {
            authGroups = new ArrayList<PermissionGroup>();
            for (int i = 0; i < allGroups.size(); ++i) {
                if (((PermissionGroup)allGroups.get(i)).getLevel() >= user.getPermissionGroup().getLevel()) continue;
                authGroups.add((PermissionGroup)allGroups.get(i));
            }
        }
        return authGroups;
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupPermissionsPanel.this.applyPermissionGroup(SetupPermissionsPanel.this.getSelectedPermissionGroup());
                }
            });
        }
    }
}

