/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.users;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.users.users.UserEditorPanel;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.objectsearch.UserSearchState;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.queries.users.PermissionGroupQueries;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class UsersSetupState<T extends User>
extends AbstractEditableTableState<T> {
    private PersistentObjectTable<T> gui;
    private JDialog accessDeniedDialog;
    private final Class<T> userType;
    private UserEditorPanel userEditorPanel;
    private boolean canEditHo = false;
    private Action newAction;
    private Action editAction;
    private Action deleteAction;

    public UsersSetupState(Class<T> displayingType, Permission permission) {
        this(displayingType, permission, new UserEditorPanel());
    }

    public UsersSetupState(Class<T> displayingType, Permission permission, ObjectEditor<T> objectEditor) {
        this("Staff Users", permission, displayingType, objectEditor);
    }

    public UsersSetupState(String stateName, Permission permission, Class<T> displayingType, ObjectEditor<T> objectEditor) {
        super(stateName, permission, "View, create and modify users.", objectEditor);
        this.userType = displayingType;
        this.userEditorPanel = (UserEditorPanel)objectEditor;
        this.userEditorPanel.setName("userEditorPanel");
        this.setSmallIcon(IconLoader.get((String)"/ordermate/images/users.png"));
        JOptionPane pane = new JOptionPane("You do not have permission to change this user", 0);
        this.accessDeniedDialog = pane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Can not change user");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy());
    }

    public void setCanEditHeadOfficeUser(boolean value) {
        this.canEditHo = value;
    }

    @Override
    protected void createActions() {
        this.addAction(this.getNewAction());
        super.createActions();
    }

    @Override
    protected OfficeMateObjectSearch<T> createSearchPanelFactory() {
        return new UserSearchState<User>(User.class);
    }

    @Override
    protected ObjectEditor<T> createObjectEditor() {
        this.userEditorPanel = new UserEditorPanel();
        return this.userEditorPanel;
    }

    @Override
    protected boolean doEdit(T object) {
        T user = object;
        if (!this.canModify((User)user)) {
            return false;
        }
        return super.doEdit(object);
    }

    private boolean canModify(User value) {
        User omUser = LoginState.getInstance().getUser();
        if (!omUser.isSystemAdministrator() && (!omUser.hasPermission(this.getEditUsersPermission()) || value.getCachedPermissionGroup() != null && value.getCachedPermissionGroup().getLevel() > omUser.getCachedPermissionGroup().getLevel())) {
            this.accessDeniedDialog.setLocationRelativeTo(GuiApp.getAppComplex().getApplicationFrame().getFrame());
            this.accessDeniedDialog.setVisible(true);
            return false;
        }
        if (value.isHeadOffice() && !this.canEditHo) {
            Dialogs.showInfoDialog("Head Office User", "Cannot edit this user. Please edit at Head Office.");
            return false;
        }
        return true;
    }

    private boolean canDelete(User user) {
        User omUser = LoginState.getInstance().getUser();
        if (!omUser.isSystemAdministrator() && !omUser.hasPermission(this.getDeleteUsersPermission())) {
            Dialogs.showErrorDialog("Cannot delete user", "You do not have sufficient privileges to delete the user");
            return false;
        }
        if (user.isClockedOn()) {
            Dialogs.showErrorDialog("Cannot delete user!", "This user is currently clocked on.\r\nA user cannot be deleted while still clocked on.");
            return false;
        }
        return true;
    }

    @Override
    protected void doDelete(List<T> toDelete) {
        for (User user : toDelete) {
            if (this.canDelete(user) && this.canModify(user)) continue;
            return;
        }
        super.doDelete(toDelete);
    }

    @Override
    public String getTypeName() {
        return "Staff User";
    }

    @Override
    protected TableStateCentralArea<T> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(User.Properties.FIRST_NAME), new PropertyColumnFormat(User.Properties.LAST_NAME), new PropertyAccessorColumnFormat(User.Properties.PERMISSION_GROUP, (PropertiedObject.Property)PermissionGroup.Properties.DISPLAY_LABEL), new PropertyColumnFormat(User.Properties.PAYROLL_ID), new PropertyColumnFormat(User.Properties.CARD_ID)});
        this.gui = new PersistentObjectTable(this.getObjectList(), format);
        this.gui.add((Component)this.getSearchFactory().getSearchPanel(), "North");
        return this.gui;
    }

    @Override
    public Class<T> getDisplayingType() {
        return this.userType;
    }

    @Override
    public Action getNewAction() {
        if (this.newAction == null) {
            this.newAction = new NewAction();
        }
        return this.newAction;
    }

    @Override
    public Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditAction();
        }
        return this.editAction;
    }

    @Override
    public Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    @Override
    protected boolean doDialog(T object) {
        boolean result = super.doDialog(object);
        if (!result) {
            this.userEditorPanel.cancel();
        } else {
            this.userEditorPanel.save();
            this.gotObjectEdited(object);
        }
        return result;
    }

    protected Permission getAddUserPermission() {
        return AllPermissions.ADD_USERS;
    }

    protected Permission getDeleteUsersPermission() {
        return AllPermissions.DELETE_USERS;
    }

    protected Permission getEditUsersPermission() {
        return AllPermissions.EDIT_USERS;
    }

    protected class NewAction
    extends PermissibleAction {
        public NewAction() {
            super("New", UsersSetupState.this.getAddUserPermission(), LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Create New", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            User newObj = (User)UsersSetupState.this.createNewObject();
            this.setDefaultPermissionGroup(newObj);
            this.setDefaultDepartment(newObj);
            if (UsersSetupState.this.doDialog(newObj)) {
                EventList objectList = UsersSetupState.this.getObjectList();
                objectList.getReadWriteLock().writeLock().lock();
                try {
                    objectList.add((Object)newObj);
                }
                finally {
                    objectList.getReadWriteLock().writeLock().unlock();
                }
            }
        }

        private void setDefaultDepartment(T newObj) {
            Department defaultDept = DepartmentQueries.getFirstDepartment();
            if (defaultDept == null) {
                throw new IllegalStateException("System does not have any departments to assign payrates to!");
            }
            Payrate defaultPayrate = new Payrate(newObj, defaultDept);
            newObj.addPayrate(defaultPayrate);
        }

        private void setDefaultPermissionGroup(T newObj) {
            PermissionGroup defaultPg = PermissionGroupQueries.getDefaultPermissionGroup();
            if (defaultPg == null) {
                throw new IllegalStateException("System does not have a permission group!");
            }
            newObj.setPermissionGroup(defaultPg);
        }
    }

    protected class DeleteAction
    extends PermissibleAction {
        public DeleteAction() {
            super("Delete", UsersSetupState.this.getDeleteUsersPermission(), LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Delete", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        public void actionPerformed(ActionEvent e) {
            List selected = UsersSetupState.this.getCentralArea().getAllSelectedObjects();
            UsersSetupState.this.doDelete(selected);
        }
    }

    protected class EditAction
    extends PermissibleAction {
        public EditAction() {
            super("Edit", UsersSetupState.this.getEditUsersPermission(), LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        public void actionPerformed(ActionEvent e) {
            User editObj = (User)UsersSetupState.this.getCentralArea().getSelectedObject();
            UsersSetupState.this.doEdit(editObj);
        }
    }
}

