/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class CircularIcon
extends JLabel {
    private ImageIcon imageIcon;
    private static final int COMPONENT_WIDTH = 65;
    private static final int COMPONENT_HEIGHT = 65;
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;
    private RadialGradientPaint radialGradientPaint;

    public CircularIcon(ImageIcon icon) {
        this.imageIcon = icon;
        this.setForeground(Color.BLACK);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(65, 65);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        int iconWidth = 16;
        int iconHeight = 16;
        int imageXOffset = 5;
        int imageYOffset = 5;
        this.radialGradientPaint = new RadialGradientPaint(width / 2, (float)(height / 2), width / 2, new float[]{0.0f, 1.0f}, new Color[]{new Color(100, 100, 100), new Color(240, 240, 240)});
        if (height < 24) {
            iconWidth = 16;
            iconHeight = 16;
            imageXOffset = 3;
            imageYOffset = 3;
        }
        if (width > height) {
            width = height;
        } else {
            height = width;
        }
        ((Graphics2D)g).setPaint(this.radialGradientPaint);
        g.fillOval(0, 0, width, height);
        g.setColor(Color.WHITE);
        g.fillOval(imageXOffset, imageYOffset, width - imageXOffset, height - imageYOffset);
        g.drawImage(this.imageIcon.getImage(), (width - iconWidth) / 2 + 3, (height - iconHeight) / 2 + 3, iconWidth, iconHeight, null);
    }
}

