/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class FloatingButtonFrame
extends JInternalFrame {
    private static FloatingButtonFrame instance = null;
    private RoundedButton roundedButton;

    public FloatingButtonFrame(Action action) {
        super("", false, false, false, false);
        instance = this;
        this.setBorder(ComponentUtils.EMPTY_BORDER);
        this.setBackground(ComponentColors.TRANSPARENT_COLOR);
        this.getContentPane().setLayout(new BorderLayout());
        InternalFrameUI ifu = this.getUI();
        ((BasicInternalFrameUI)ifu).setNorthPane(null);
        this.setSize(ComponentUtils.DIM_32);
        this.roundedButton = new RoundedButton(IconLoader.get((String)"/officemate/images/expandlr.png"));
        this.roundedButton.setName("floatingButton");
        this.getContentPane().add((Component)this.roundedButton, "Center");
        this.setOpaque(false);
        this.setVisible(true);
        this.roundedButton.addActionListener(action);
    }

    public static void showFloatingFrame(boolean show) {
        if (instance != null) {
            instance.setVisible(show);
            if (show) {
                instance.toFront();
            } else {
                instance.toBack();
            }
        }
    }

    public class RoundedButton
    extends JButton {
        private ImageIcon icon;
        RadialGradientPaint gradientPaintLight = null;
        RadialGradientPaint gradientPaintDark = null;

        public RoundedButton(ImageIcon icon) {
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setBackground(ComponentColors.TRANSPARENT_COLOR);
            this.icon = icon;
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.initGradients(this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ButtonModel model = this.getModel();
            RadialGradientPaint radialGradientPaint = null;
            radialGradientPaint = model.isRollover() || model.isPressed() ? this.gradientPaintDark : this.gradientPaintLight;
            g2.setPaint(radialGradientPaint);
            g2.fillRoundRect(0, 0, this.getHeight(), this.getHeight(), this.getHeight(), this.getHeight());
            g2.drawImage(this.icon.getImage(), 6, 8, null);
        }

        @Override
        public void paintImmediately(int x, int y, int w, int h) {
            super.paintImmediately(0, 0, 0, 0);
        }

        private void initGradients(JComponent c) {
            Float height = Float.valueOf(new Integer(String.valueOf(c.getHeight())).floatValue());
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] darkerColors = new Color[]{ComponentColors.LIGHT_GRAY, ComponentColors.ERROR_PANEL_BG_COLOR};
            Color[] colors = new Color[]{ComponentColors.WHITE, ComponentColors.LIGHT_GRAY};
            if (this.gradientPaintLight == null) {
                Point2D.Float center = new Point2D.Float(height.floatValue() / 2.0f, height.floatValue() / 2.0f);
                this.gradientPaintLight = new RadialGradientPaint(center, height.floatValue(), center, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                this.gradientPaintDark = new RadialGradientPaint(center, height.floatValue(), center, dist, darkerColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            }
        }
    }
}

