/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.state.welcome.CircularIcon;
import officemate.adminkit.state.welcome.MouseClickAdapter;

public class KnowledgebaseItem
extends JPanel {
    private JTextArea textArea;
    private JLabel titleLabel;
    private JLabel circularIcon;
    private final String title;
    private final String content;
    private final String iconPath;
    private final String URL;
    private final Insets insets = new Insets(0, 10, 0, 10);
    private MouseClickAdapter mouseClickAdapter;

    public KnowledgebaseItem(String title, String content, String iconPath, String URL2) {
        this.title = title;
        this.content = content;
        this.iconPath = iconPath;
        this.URL = URL2;
        this.init();
    }

    private void init() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.setOpaque(false);
        this.mouseClickAdapter = new MouseClickAdapter(this.URL);
        this.addCircularIcon();
        this.addTitleLabel();
        this.addDescription();
        this.addMouseListener(this.mouseClickAdapter);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.circularIcon.setPreferredSize(new Dimension(height, height));
    }

    private void addCircularIcon() {
        this.circularIcon = new CircularIcon(IconLoader.get((String)this.iconPath));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 2, 0.1, 0.1, 21, 1, this.insets, 0, 0);
        this.add((Component)this.circularIcon, gbc);
    }

    private void addTitleLabel() {
        this.titleLabel = new JLabel(this.title);
        this.titleLabel.setForeground(new Color(50, 105, 134));
        this.titleLabel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, this.insets, 0, 0);
        this.add((Component)this.titleLabel, gbc);
        this.titleLabel.setName(this.title);
    }

    private void addDescription() {
        this.textArea = new JTextArea();
        this.textArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textArea.setText(this.content);
        this.textArea.setEditable(false);
        this.textArea.setForeground(new Color(150, 150, 150));
        this.textArea.setOpaque(false);
        this.textArea.setFont(ComponentUtils.SANS_SERIF_PLAIN_11);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.addMouseListener(this.mouseClickAdapter);
        GridBagConstraints gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 21, 1, this.insets, 0, 0);
        this.add((Component)this.textArea, gbc);
    }
}

