/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageResizeHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.LayerUI;

public class RightPolygon
extends LayerUI<JComponent> {
    private Polygon createRightPolygon(JComponent jc) {
        int width = jc.getWidth();
        int height = jc.getHeight();
        int pTopStartX = MathsUtils.getPercentageOf((int)width, (int)91);
        int pBottomStartX = MathsUtils.getPercentageOf((int)width, (int)65);
        int[] polX = new int[]{pTopStartX, width, width, pBottomStartX};
        int[] polY = new int[]{0, 0, height, height};
        return new Polygon(polX, polY, polX.length);
    }

    private Image createLogo() {
        double newWidth = 200.0;
        ImageIcon logoIcon = IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png");
        double scaleFactor = 200.0 / (double)logoIcon.getIconWidth();
        ImageResizeHelper imageResizeHelper = new ImageResizeHelper();
        return imageResizeHelper.rescaleImageIcon(logoIcon, scaleFactor, 4).getImage();
    }

    private void drawLogo(Graphics2D g2, JComponent jc) {
        Image logoImage = this.createLogo();
        Polygon polygon = this.createRightPolygon(jc);
        int bottomStartX = polygon.xpoints[3];
        int bottomStartY = polygon.ypoints[3];
        int width = polygon.xpoints[2] - polygon.xpoints[3];
        int imageWidth = logoImage.getWidth(null);
        int imageHeight = logoImage.getHeight(null);
        int imageStartX = bottomStartX + (width - imageWidth) / 2 + 20;
        int imageStartY = bottomStartY - imageHeight - 25;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(logoImage, imageStartX, imageStartY, null);
    }

    @Override
    public void paint(Graphics g, JComponent jc) {
        super.paint(g, jc);
        Graphics2D g2 = (Graphics2D)g;
        this.drawGradientPolygon(g2, jc);
        this.drawLogo(g2, jc);
    }

    private void drawGradientPolygon(Graphics2D g2, JComponent jc) {
        Polygon polygon = this.createRightPolygon(jc);
        Point p1 = new Point(polygon.xpoints[0], polygon.ypoints[0]);
        Point p2 = new Point(polygon.xpoints[1], polygon.ypoints[1]);
        Point p3 = new Point(polygon.xpoints[2], polygon.ypoints[2]);
        Point p4 = new Point(polygon.xpoints[3], polygon.ypoints[3]);
        Polygon smallPolygon = new Polygon();
        smallPolygon.addPoint(p1.x, p1.y);
        smallPolygon.addPoint(p2.x, p2.y);
        smallPolygon.addPoint(p3.x, p3.y);
        smallPolygon.addPoint(p4.x, p4.y);
        Point startLgp = new Point((p1.x - p4.x) / 2, (p4.y - p1.y) / 2);
        Point endLgp = new Point(polygon.xpoints[2], polygon.ypoints[2]);
        LinearGradientPaint lgp = new LinearGradientPaint(startLgp, endLgp, new float[]{0.0f, 1.0f}, new Color[]{ComponentColors.WELCOME_GRADIENT_START, ComponentColors.WELCOME_GRADIENT_END});
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(lgp);
        g2.fillPolygon(smallPolygon);
    }
}

