/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Assert;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.table.DefaultObjectTableModel;
import officemate.adminkit.table.ObjectTable;
import officemate.adminkit.table.ObjectTableModel;
import officemate.adminkit.table.ShadeAlternateRowsBooleanTableCellRenderer;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.components.tableformat.renderers.ColorCellRenderer;

public class DefaultObjectTable
extends ObjectTable {
    private ObjectTableModel model;
    private ObjectTemplate template;

    public DefaultObjectTable(ObjectTemplate objTemp) {
        this(objTemp, null, null);
    }

    public DefaultObjectTable(ObjectTemplate objTemp, String[] fieldsToDisplay, ObjectFilter filter) {
        this(new DefaultObjectTableModel(objTemp, fieldsToDisplay, filter), objTemp);
    }

    public DefaultObjectTable(DefaultObjectTableModel newModel, ObjectTemplate objTemp) {
        Assert.isTrue((objTemp != null ? 1 : 0) != 0, (String)"Object template must not be null");
        this.template = objTemp;
        this.model = newModel;
        this.setCellRendererForAll(new ShadeAlternateRowsTableCellRenderer());
        this.defaultRenderersByColumnClass.put(Boolean.class, new ShadeAlternateRowsBooleanTableCellRenderer());
        this.defaultRenderersByColumnClass.put(Color.class, new ColorCellRenderer());
        this.init(this.model, this.model.getColumnModel());
    }

    public void setObjectFilter(ObjectFilter filter) {
        this.model.setObjectFilter(filter);
    }

    public ObjectFilter getObjectFilter() {
        return this.model.getObjectFilter();
    }

    public ObjectTemplate getTemplate() {
        return this.template;
    }

    public void addObject(Object obj) {
        this.getObjectModel().addObject(obj);
    }

    public void removeObject(Object obj) {
        this.getObjectModel().removeObject(obj);
    }

    public void setObjects(List objects) {
        this.getObjectModel().setObjects(objects);
    }

    public List getObjects() {
        return new ArrayList(this.getObjectModel().getObjects());
    }

    public void setObjectTableModel(DefaultObjectTableModel newModel) {
        this.model = newModel;
    }
}

