/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import officemate.adminkit.table.GroupedTableCellRenderer;
import officemate.adminkit.table.GroupedTableModel;
import officemate.adminkit.table.TableColumnUtility;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class GroupedTable
extends JXTable {
    public Signal objectSelected = Signals.createSignal(Integer.class, (String)"tableIndex");
    public Signal objectDeselected = Signals.createSignal(Integer.class, (String)"tableIndex");
    public Signal objectChosen = Signals.createSignal(Integer.class, (String)"tableIndex");
    private Integer currentSelectedIndex;
    private JScrollPane scroller;
    private GroupedTableModel groupedModel;
    private boolean initialised = false;
    private final TableColumnUtility columnUtil;

    public GroupedTable(GroupedTableModel groupModel, List<TableColumn> oldColumns) {
        this(groupModel);
        for (TableColumn nextOldColumn : oldColumns) {
            for (TableColumn nextColumn : this.getColumns(true)) {
                if (!nextColumn.getHeaderValue().equals(nextOldColumn.getHeaderValue())) continue;
                nextColumn.setIdentifier(nextOldColumn.getIdentifier());
                nextColumn.setCellEditor(nextOldColumn.getCellEditor());
                nextColumn.setCellRenderer(nextOldColumn.getCellRenderer());
            }
        }
    }

    public GroupedTable(GroupedTableModel groupModel) {
        this.groupedModel = groupModel;
        this.setModel(this.groupedModel);
        this.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new GroupedTableCellRenderer());
        this.scroller = new JScrollPane((Component)((Object)this), 20, 30);
        this.setShowVerticalLines(false);
        this.addKeyListener(new InnerListener());
        this.addMouseListener(new InnerListener());
        this.columnUtil = new TableColumnUtility((JTable)((Object)this));
        this.setSortable(false);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping((Color)Color.WHITE)});
        this.initialised = true;
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        return editor.getTableCellEditorComponent((JTable)((Object)this), null, true, row, column);
    }

    public void setModel(TableModel model) {
        if (model instanceof GroupedTableModel) {
            this.groupedModel = (GroupedTableModel)model;
        }
        super.setModel(model);
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }

    public GroupedTableModel getGroupedTableModel() {
        return this.groupedModel;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (renderer == null) {
            return new DefaultTableCellRenderer();
        }
        return renderer;
    }

    public void setCellRendererForAll(TableCellRenderer renderer) {
        Set entries = this.defaultRenderersByColumnClass.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue(renderer);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.initialised && !e.getValueIsAdjusting()) {
            Integer newIndex = this.getSelectedRow();
            if (this.currentSelectedIndex != null && !newIndex.equals(this.currentSelectedIndex)) {
                this.objectDeselected.emit((Object)this.currentSelectedIndex);
            }
            this.objectSelected.emit((Object)newIndex);
            this.currentSelectedIndex = newIndex;
        }
    }

    public void packColumns() {
        this.columnUtil.packAll();
    }

    private class InnerListener
    implements MouseListener,
    KeyListener {
        private InnerListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.onObjectChosen();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.onObjectChosen();
            }
        }

        private void onObjectChosen() {
            GroupedTable.this.objectChosen.emit((Object)GroupedTable.this.getSelectedRow());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

