/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Assert;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LinkedTotalTable
extends JTable {
    private TableColumnModel linkedColModel;
    private TableColumnModelListener columnListener = new InnerColumnListener();

    public LinkedTotalTable(TableColumnModel linkedColumnModel) {
        super(new DefaultTableModel(1, linkedColumnModel.getColumnCount()));
        this.setLinkedColumnModel(linkedColumnModel);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LinkedTotalTable.this.getSelectionModel().clearSelection();
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setColumnValues(Object[] values) {
        Assert.isEqual((int)this.getColumnCount(), (int)values.length, (String)"Different number of column values than columns");
        for (int i = 0; i < values.length; ++i) {
            this.setValueAt(values[i], 0, i);
        }
    }

    public Object[] getColumnValues() {
        int numCols = this.getColumnCount();
        Object[] values = new Object[numCols];
        for (int i = 0; i < numCols; ++i) {
            values[i] = this.getValueAt(0, i);
        }
        return values;
    }

    public String[] getColumnStrings() {
        int numCols = this.getColumnCount();
        String[] values = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            Object val = this.getValueAt(0, i);
            values[i] = val != null ? val.toString() : " - ";
        }
        return values;
    }

    public void setLinkedColumnModel(TableColumnModel newModel) {
        if (this.linkedColModel != null) {
            this.linkedColModel.removeColumnModelListener(this.columnListener);
        }
        this.linkedColModel = newModel;
        TableColumnModel oldModel = this.getColumnModel();
        int numCols = oldModel.getColumnCount();
        int minCols = Math.min(numCols, newModel.getColumnCount());
        for (int i = 0; i < minCols; ++i) {
            TableColumn oldCol = oldModel.getColumn(i);
            TableColumn newCol = newModel.getColumn(i);
            oldCol.setModelIndex(newCol.getModelIndex());
            oldCol.setIdentifier(newCol.getIdentifier());
            oldCol.setMaxWidth(newCol.getMaxWidth());
            oldCol.setMinWidth(newCol.getMinWidth());
            oldCol.setPreferredWidth(newCol.getPreferredWidth());
            oldCol.setWidth(oldCol.getWidth());
        }
        newModel.addColumnModelListener(this.columnListener);
        this.repaint();
    }

    private class InnerColumnListener
    implements TableColumnModelListener {
        private InnerColumnListener() {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            LinkedTotalTable.this.setLinkedColumnModel(LinkedTotalTable.this.linkedColModel);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            LinkedTotalTable.this.setLinkedColumnModel(LinkedTotalTable.this.linkedColModel);
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            LinkedTotalTable.this.setLinkedColumnModel(LinkedTotalTable.this.linkedColModel);
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            LinkedTotalTable.this.setLinkedColumnModel(LinkedTotalTable.this.linkedColModel);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            LinkedTotalTable.this.setLinkedColumnModel(LinkedTotalTable.this.linkedColModel);
        }
    }

    protected static class NonEditableTableModel
    extends DefaultTableModel {
        protected NonEditableTableModel() {
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }
    }
}

