/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Assert;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import officemate.adminkit.table.ObjectTableModel;
import officemate.adminkit.table.TableSorter;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ObjectTable
extends JTable {
    public Signal objectSelected = Signals.createSignal(Object.class, (String)"obj");
    public Signal objectDeselected = Signals.createSignal(Object.class, (String)"obj");
    public Signal objectChosen = Signals.createSignal(Object.class, (String)"obj");
    private JScrollPane scroller;
    private Object currentSelected;
    private TableSorter modelWrapper;
    private boolean initialised = false;

    public ObjectTable(ObjectTableModel model, TableColumnModel colModel) {
        super(model, colModel);
        this.init(model, colModel);
    }

    protected ObjectTable() {
        super(new EmptyObjectTableModel());
    }

    public void setCellRendererForAll(TableCellRenderer renderer) {
        Set entries = this.defaultRenderersByColumnClass.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue(renderer);
        }
    }

    protected final void init(ObjectTableModel model, TableColumnModel colModel) {
        Assert.isTrue((!this.initialised ? 1 : 0) != 0, (String)"Can only call init() if the table has not already been initialised");
        this.scroller = new JScrollPane(this, 20, 30);
        if (this.modelWrapper == null) {
            this.modelWrapper = new TableSorter();
        }
        this.modelWrapper.setTableModel(model);
        this.modelWrapper.setTableHeader(this.getTableHeader());
        super.setModel(this.modelWrapper);
        super.setColumnModel(colModel);
        this.getSelectionModel().setSelectionMode(0);
        this.addMouseListener(new InnerListener());
        this.addKeyListener(new InnerListener());
        this.initialised = true;
    }

    public void setSortingStatus(int column, int direction) {
        this.modelWrapper.setSortingStatus(column, direction);
    }

    public void setSortingStatus(String column, int direction) {
        int index = this.getObjectModel().findColumn(column);
        this.modelWrapper.setSortingStatus(index, direction);
    }

    public ObjectTableModel getObjectModel() {
        return (ObjectTableModel)((TableSorter)this.getModel()).getTableModel();
    }

    @Override
    public void setModel(TableModel model) {
        Assert.isInstanceOf((Object)model, ObjectTableModel.class, (String)"TableModel must be an ObjectTableModel.");
        if (this.modelWrapper == null) {
            this.modelWrapper = new TableSorter();
            this.modelWrapper.setTableHeader(this.getTableHeader());
        }
        this.modelWrapper.setTableModel(model);
        super.setModel(this.modelWrapper);
    }

    public boolean hasObject(Object o) {
        return ((ObjectTableModel)this.getModel()).hasObject(o);
    }

    public boolean hasVisibleObject(Object o) {
        return ((ObjectTableModel)this.getModel()).hasVisibleObject(o);
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (renderer == null) {
            return new DefaultTableCellRenderer();
        }
        return renderer;
    }

    public Object getObjectForVisibleRow(int visibleRow) {
        int row = visibleRow;
        if (row != -1) {
            row = this.modelWrapper.modelIndex(row);
            ObjectTableModel objTableModel = (ObjectTableModel)this.modelWrapper.getTableModel();
            return objTableModel.getObjectForRow(row);
        }
        return null;
    }

    public Object getSelectedObject() {
        if (this.getModel().getRowCount() > 0) {
            int row = this.getSelectedRow();
            return this.getObjectForVisibleRow(row);
        }
        return null;
    }

    public void setSelectedObject(Object o) {
        int row = -1;
        List objects = this.getObjectModel().getObjects();
        for (int i = 0; i < objects.size(); ++i) {
            Object obj = objects.get(i);
            if (!obj.equals(o)) continue;
            row = i;
            break;
        }
        if (row != -1) {
            this.setRowSelectionInterval(row, row);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.initialised && !e.getValueIsAdjusting()) {
            Object newSelected = this.getSelectedObject();
            if (this.currentSelected != null && newSelected != this.currentSelected) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.objectDeselected.emit(this.currentSelected);
            }
            this.objectSelected.emit(newSelected);
            this.currentSelected = newSelected;
        }
    }

    private class InnerListener
    implements MouseListener,
    KeyListener {
        private InnerListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.onObjectChosen();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.onObjectChosen();
            }
        }

        private void onObjectChosen() {
            ObjectTable.this.objectChosen.emit(ObjectTable.this.getSelectedObject());
        }
    }

    private static class EmptyObjectTableModel
    extends ObjectTableModel {
        private EmptyObjectTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public TableColumnModel getColumnModel() {
            return null;
        }

        @Override
        public String getFieldForColumn(int col) {
            return null;
        }

        @Override
        public Object getValueForField(Object obj, String prop) {
            return null;
        }
    }
}

