/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import officemate.adminkit.table.TableColumnUtility;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class QueryTable
extends JTable {
    public final Signal<Long, ?, ?, ?, ?> objectSelected = Signals.createSignal(Long.class, (String)"objectID");
    public final Signal<Long, ?, ?, ?, ?> objectDeselected = Signals.createSignal(Long.class, (String)"objectID");
    public final Signal<Long, ?, ?, ?, ?> objectChosen = Signals.createSignal(Long.class, (String)"objectID");
    private final JScrollPane scroller;
    private Long currentSelected;
    private QueryTableModel queryModel;
    private boolean initialised = false;
    private final TableColumnUtility columnUtil;
    private boolean packColumns = true;

    public QueryTable(QueryTableModel model) {
        this.queryModel = model;
        this.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new ShadeAlternateRowsTableCellRenderer());
        this.scroller = new JScrollPane(this, 20, 30);
        this.scroller.setName("scroller");
        model.setTableHeader(this.getTableHeader());
        this.setModel(model);
        this.addKeyListener(new InnerListener());
        this.addMouseListener(new InnerListener());
        this.columnUtil = new TableColumnUtility(this);
        this.initialised = true;
    }

    @Override
    public void setModel(TableModel model) {
        if (model instanceof QueryTableModel) {
            this.queryModel = (QueryTableModel)model;
        }
        super.setModel(model);
    }

    public JScrollPane getScroller() {
        return this.scroller;
    }

    public void updateModel() {
        this.getQueryTableModel().update();
        this.packColumns();
    }

    public QueryTableModel getQueryTableModel() {
        return this.queryModel;
    }

    public Number[] getTotals() {
        return this.getQueryTableModel().getTotals();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.initialised && !e.getValueIsAdjusting()) {
            Long newSelected = new Long(this.getSelectedObjectID());
            if (this.currentSelected != null && !newSelected.equals(this.currentSelected)) {
                this.objectDeselected.emit((Object)this.currentSelected);
            }
            this.objectSelected.emit((Object)newSelected);
            this.currentSelected = newSelected;
        }
    }

    public long getSelectedObjectID() {
        return this.getQueryTableModel().getID(this.getSelectedRow());
    }

    public List<Integer> getSelectedObjectIDs() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int row : this.getSelectedRows()) {
            ids.add(this.getQueryTableModel().getID(row).intValue());
        }
        return ids;
    }

    public long getObjectID(int row) {
        return this.getQueryTableModel().getID(row);
    }

    public void setSelectedObjectID(Long id) {
        int row = this.getQueryTableModel().getRow(id);
        if (row != -1) {
            this.setRowSelectionInterval(row, row);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (renderer == null) {
            return new DefaultTableCellRenderer();
        }
        return renderer;
    }

    public void setCellRendererForAll(TableCellRenderer renderer) {
        Set entries = this.defaultRenderersByColumnClass.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue(renderer);
        }
    }

    public void packColumns() {
        if (this.packColumns) {
            this.columnUtil.packAll();
        }
    }

    public boolean isPackColumns() {
        return this.packColumns;
    }

    public void setPackColumns(boolean pack) {
        this.packColumns = pack;
    }

    private class InnerListener
    implements MouseListener,
    KeyListener {
        private InnerListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.onObjectChosen();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.onObjectChosen();
            }
        }

        private void onObjectChosen() {
            QueryTable.this.objectChosen.emit((Object)new Long(QueryTable.this.getSelectedObjectID()));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

