/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Stringifier;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ShadeAlternateRowsTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color EVEN_COLOR = Color.white;
    public static final Color ODD_COLOR = new Color(250, 250, 230);
    private Stringifier stringifier;

    public void setStringifier(Stringifier value) {
        this.stringifier = value;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.stringifier != null) {
            this.setText(this.stringifier.stringify(value));
        }
        if (!isSelected) {
            this.setBackground(this, row);
        }
        if (hasFocus && table.getModel().isCellEditable(row, column)) {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
        }
        return this;
    }

    protected void setBackground(Component comp, int row) {
        boolean evenRow = row % 2 == 0;
        comp.setBackground(evenRow ? ODD_COLOR : ODD_COLOR);
    }
}

