/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableColumnUtility {
    JTable table;

    public TableColumnUtility(JTable aTable) {
        this.table = aTable;
    }

    public void packAll() {
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.packColumn(c);
        }
    }

    public void packColumn(int c) {
        int width = 0;
        TableColumn column = this.table.getColumnModel().getColumn(c);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer != null) {
            Component comp = headerRenderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, 0, c);
            width = comp.getPreferredSize().width;
        }
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            TableCellRenderer renderer = this.table.getCellRenderer(row, c);
            Object value = this.table.getValueAt(row, c);
            Component comp = renderer.getTableCellRendererComponent(this.table, value, false, false, row, c);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        column.setPreferredWidth(width);
    }

    public int getPreferredScrollableViewportWidth() {
        int width = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            width += this.table.getColumnModel().getColumn(i).getPreferredWidth();
        }
        return width;
    }
}

