/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.types.KVPairFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.QuantityFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.setup.stock.units.UnitsUsageEditorPanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.internationalization.Internationalization;

public class MenuItemUnitTemplate
extends ObjectTemplate {
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    public static final String NAME = "Name";
    public static final String STOCK_USAGE = "Stock Usage";
    public static final String PORTION = "Portion";
    public static final String SIZE = "Size";
    public static final String COST = "Cost Ex " + GST;
    public static final String USAGE_QUANTITY = "Usage Qty";
    public static final String STOCK_USAGE_STOCK_USED = "Stock Used";
    public static final String STOCK_USAGE_QUANTITY_USED = "Quantity Used";

    public MenuItemUnitTemplate() {
        super("Menu Item Unit", InventoryItemUnit.class);
        this.setObjectTextProp("label");
        this.addReadOnlyEntry(NAME, new StringFieldType(), "itemLabel", "The name of the item");
        this.addEntry(STOCK_USAGE, new KVPairFieldType("ingredient link", new ObjectRefFieldType(StockItem.class, false, false, false, StockItemSearchPanel.class), STOCK_USAGE_STOCK_USED, "The type of stock used.", new QuantityFieldType(0.0, 9999999.0, 1.0), STOCK_USAGE_QUANTITY_USED, "The quantity used for each item sold.", UnitsUsageEditorPanel.class){

            @Override
            public String getValueName() {
                return "Ingredients";
            }
        }, "stockUsage", "The quantity of stock used, for various stock types. ");
        this.addReadOnlyEntry(PORTION, new StringFieldType(), "portionLabel", "The portion of the item, eg. 'Whole' or 'Half'");
        this.addReadOnlyEntry(SIZE, new StringFieldType(), "sizeLabel", "The size of the item, eg. 'Main' or 'Entree'");
        this.addReadOnlyEntry(COST, new PriceFieldType(0.0, 9.99999999E8, 0.0), "ingredientCostExTax", "The cost of this item.");
        this.addReadOnlyEntry(USAGE_QUANTITY, new StringFieldType(), "stockUsageDescString", "A brief description of the stock usage.");
    }
}

