/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import au.com.ordermate.util.Stringifier;
import officemate.adminkit.Enum;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.searchpanels.TriggerSearchPanel;
import officemate.adminkit.types.BusinessObjectType;
import officemate.adminkit.types.EnumFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.SearchArrayFieldType;
import officemate.screens.setup.menu.pricelevels.PriceLevelEditorPanel;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.PriceLevelRule;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;

public class PriceLevelTemplate
extends ObjectTemplate {
    public PriceLevelTemplate() {
        super("Price Level", PriceLevel.class);
        this.setObjectTextProp("label");
        this.addEntry("Name", PriceLevel.Properties.LABEL, "The price levels name");
        this.addReadOnlyEntry(PriceLevel.Properties.SEQUENCE.getUserVisibleLabel(), new IntFieldType(), PriceLevel.Properties.SEQUENCE.getName(), "The price levels sequence");
        this.addEntry(PriceLevel.Properties.SHOW_ON_RECEIPT, "Whether to show the price level change on the receipt");
        this.addEntry(PriceLevel.Properties.DEFAULT_LEVEL, "Sets the price level as the default level");
        Enum triggerEnum = new Enum("TriggerActivation", new Object[]{TriggerActivationStrategy.ALL_TRIGGERS, TriggerActivationStrategy.ANY_TRIGGERS});
        this.addEntry(PriceLevel.Properties.TRIGGER_ACTIVATION_STRATEGY, (FieldType)new EnumFieldType(triggerEnum, 2, TriggerActivationStrategy.ANY_TRIGGERS), "Do all triggers need to be active for the price level to be active");
        SearchArrayFieldType triggers = new SearchArrayFieldType((FieldType)new BusinessObjectType(AbstractTrigger.class, DefaultTrigger.class), TriggerSearchPanel.class, false);
        this.addEntry("Triggers", (FieldType)triggers, "Triggers associated with this Price Level");
        this.addEntry(PriceLevel.Properties.REFERENCE_PRICE_LEVEL, (FieldType)new ObjectRefFieldType(PriceLevel.class), "Select the reference price level to auto fill out the prices");
        this.setSeparator(PriceLevel.Properties.REFERENCE_PRICE_LEVEL, "Auto fill out Prices");
        this.addEntry(PriceLevel.Properties.DOLLAR_TO_APPLY, "The value to add or remove from the reference price");
        this.addEntry(PriceLevel.Properties.PERCENTAGE_TO_APPLY, "The percentage to add or remove from the reference price");
        Enum rules = new Enum("Rule", PriceLevelRule.values());
        EnumFieldType type = new EnumFieldType(rules, 2, PriceLevelRule.NULL_RULE);
        type.setStringifier(new Stringifier(){

            public String stringify(Object value) {
                if (value != null && value instanceof PriceLevelRule) {
                    return ((PriceLevelRule)value).getLabel();
                }
                return String.valueOf(value);
            }
        });
        type.setToolTipStringifier(new Stringifier(){

            public String stringify(Object value) {
                if (value != null && value instanceof PriceLevelRule) {
                    return ((PriceLevelRule)value).getDescription();
                }
                return String.valueOf(value);
            }
        });
        this.addEntry(PriceLevel.Properties.RULE_TO_APPLY, (FieldType)type, "How the auto fill out of prices will process.");
        this.setEditPanelClass(PriceLevelEditorPanel.class);
    }
}

