/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import java.text.MessageFormat;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.maintainstock.invoice.StockInvoiceEntryEditorPanel;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.internationalization.Internationalization;

public class StockInvoiceEntryTemplate
extends ObjectTemplate {
    public static final String GST = Internationalization.getLiteralFor((String)"GST");
    public static final String STOCK_ITEM = "Stock Item";
    public static final String QUANTITY = "Qty";
    public static final String BONUS_QUANTITY = "Bonus Qty";
    public static final String COST_PER_UNIT = "Cost Per Unit";
    public static final String OLD_COST = "Old cost";
    public static final String COST_INC_GST = MessageFormat.format("Cost (Inc {0})", GST);
    public static final String COST_EX_GST = MessageFormat.format("Cost (Ex {0})", GST);
    public static final String COST_OVERRIDE = "Cost Override";
    public static final String OUTER_QUANTITY = "Quantity";
    public static final String OUTER_BONUS_QUANTITY = "Bonus";

    public StockInvoiceEntryTemplate() {
        super("Invoice Entry", StockInvoiceEntry.class);
        this.setObjectTextProp("label");
        this.addEntry(STOCK_ITEM, new ObjectRefFieldType(StockItem.class, true, true, false, null), "stockItem", "The stock item that was received.");
        this.addEntry(QUANTITY, new DoubleFieldType(0.0, 999999.0, 1.0), "numReceived", "The number of stock items received.");
        this.addEntry(BONUS_QUANTITY, new IntFieldType(0, 999999, 0), "bonusReceived", "The number of free stock items received.");
        this.addEntry(COST_PER_UNIT, new PriceFieldType(0.0, 9999999.0, 0.0), "pricePaidPerUnit", "The price paid for one unit of the incoming stock items.\nThis cost per unit calculation excludes any bonus items.");
        this.addReadOnlyEntry(OLD_COST, new PriceFieldType(0.0, 9999999.0, 0.0), "stockItem.oldCost", "The cost per unit of this stock item from previous invoices.");
        this.addReadOnlyEntry(GST, new PriceFieldType(0.0, 9999999.0, 0.0), "includedTax", "The amount of Tax paid.");
        this.addReadOnlyEntry(COST_INC_GST, new PriceFieldType(0.0, 9999999.0, 0.0), "pricePaid", "The price paid for the incoming stock items with Tax. ");
        this.addReadOnlyEntry(COST_EX_GST, new PriceFieldType(0.0, 9999999.0, 0.0), "pricePaidExTax", "The price paid for the incoming stock items without Tax. ");
        this.addEntry(COST_OVERRIDE, new BoolFieldType(false), "overridesCost", "Whether or not the system average cost is overridden.");
        this.addReadOnlyEntry(OUTER_QUANTITY, new StringFieldType("", false), "outerQuantityString", "The number of stock items received.");
        this.addReadOnlyEntry(OUTER_BONUS_QUANTITY, new StringFieldType("", false), "outerBonusQuantityString", "The number of free stock items received.");
        this.setEditPanelClass(StockInvoiceEntryEditorPanel.class);
    }
}

