/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.searchpanels.StockSupplierSearchPanel;
import officemate.adminkit.types.DateFieldType;
import officemate.adminkit.types.DateTimeFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.maintainstock.invoice.StockInvoiceEditorPanel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockSupplier;

public class StockInvoiceTemplate
extends ObjectTemplate {
    public static final String SUPPLIER = "Supplier";
    public static final String ORDER_NUMBER = "Order number";
    public static final String INVOICE_NUMBER = "Invoice number";
    public static final String CREATED_ON = "Created On";
    public static final String DATE = "Date";
    public static final String INC_TAX_TOTAL = "Inc " + SystemProperty.getInstance().getBaseTaxLabel() + " Total";
    public static final String EX_TAX_TOTAL = "Ex " + SystemProperty.getInstance().getBaseTaxLabel() + " Total";
    public static final String TAX_AMOUNT = SystemProperty.getInstance().getBaseTaxLabel() + " Amount";
    public static final String TYPE = "Type";
    public static final String FREIGHT_COST = "Freight cost";
    public static final String ADMIN_COST = "Admin cost";
    public static final String DISCOUNT = "Discount";
    public static final String EXPECTED_COST = "Expected Cost";

    public StockInvoiceTemplate() {
        super("Stock Invoice", StockInvoice.class);
        this.addEntry(SUPPLIER, new ObjectRefFieldType(StockSupplier.class, true, true, false, StockSupplierSearchPanel.class), "supplier", "The supplier that this invoice is for.");
        this.addEntry(ORDER_NUMBER, new StringFieldType(), "orderNumber", "The order number that  you have associated with this invoice.");
        this.addEntry(INVOICE_NUMBER, new StringFieldType(), "invoiceNumber", "The invoice number that  the supplier has given this invoice.");
        this.addReadOnlyEntry(CREATED_ON, new DateTimeFieldType(), "creationDate", "The date and time that the invoice was created on.");
        this.addEntry(DATE, new DateFieldType(), "date", "The date of the invoice.");
        this.addReadOnlyEntry(INC_TAX_TOTAL, new PriceFieldType(), "totalCost", "The total cost of the invoice, Tax inclusive.");
        this.addReadOnlyEntry(EX_TAX_TOTAL, new PriceFieldType(), "totalCostExTax", "The total cost of the invoice, Tax exclusive.");
        this.addReadOnlyEntry(TAX_AMOUNT, new PriceFieldType(), "TaxAmount", "The value of Tax for the invoice.");
        this.addReadOnlyEntry(TYPE, new PriceFieldType(), "invoiceType", "'Invoice' or 'Credit Note'");
        this.addEntry(FREIGHT_COST, new PriceFieldType(), "freightCost", "The freight cost for this invoice.");
        this.addEntry(ADMIN_COST, new PriceFieldType(), "adminCost", "The admin cost for this invoice.");
        this.addEntry(DISCOUNT, new PriceFieldType(), "discount", "A dollar-value discount applied to this invoice.");
        this.addEntry(EXPECTED_COST, new PriceFieldType(), "expectedTotal", "The expected total value of this invoice.");
        this.setEditPanelClass(StockInvoiceEditorPanel.class);
    }
}

