/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import java.text.MessageFormat;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.types.ArrayFieldType;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.KVPairFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.QuantityFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.setup.stock.items.StockItemEditorPanel;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.internationalization.Internationalization;

public class StockItemTemplate
extends ObjectTemplate {
    public static final String GST = Internationalization.getLiteralFor((String)"GST");
    public static final String NAME = "Name";
    public static final String SHORT_NAME = "Short Name";
    public static final String SUPPLIERS_CODES = "Suppliers/Codes";
    public static final String MATCH_PRE_PROD = "Use Pre-Prod Cost";
    public static final String COST = "Purchase Cost";
    public static final String QUANTITY = "Purchase Quantity";
    public static final String INCLUDES_GST = "Includes " + GST;
    public static final String DISPLAY_MEASURE = "Measure Unit";
    public static final String INGREDIENT_MEASURE = "Ingredient measure";
    public static final String OUTER_CONTAINER = "Outer Container";
    public static final String OUTER_QUANTITY = "Outer Quantity";
    public static final String STOCK_GROUP = "Group";
    public static final String QUANTITY_ON_HAND = "Qty On Hand";
    public static final String YIELD_AS_QUANTITY = "Yield";
    public static final String BARCODES = "Barcodes";
    public static final String SUGGESTED_ORDER_MIN_MAX = "Suggested Order Min/Max";
    public static final String STOCKABLE_AREAS = "Stockable areas";

    public StockItemTemplate() {
        super("Stock Item", StockItem.class);
        this.addEntry(NAME, new StringFieldType("", false), "name", "The name of the incoming stock item unit, eg. Coca-cola slab");
        this.addEntry(SHORT_NAME, new StringFieldType("", true), "shortName", "Shorthand for the Stock Item: useful for reciepts");
        this.addEntry(SUPPLIERS_CODES, new KVPairFieldType("Supplier/code", new ObjectRefFieldType(StockSupplier.class), "Suppliers", new StringFieldType("", true), "Product Codes"), "supplierCodePairs", "Suppliers and their product codes for this item");
        this.addEntry(MATCH_PRE_PROD, new BoolFieldType(false), "replacementCostMatchPreProdCost", "Whether to use the pre-production cost for Purchase Cost");
        this.addEntry(INCLUDES_GST, new BoolFieldType(true), "taxIncluded", MessageFormat.format("Do the items include {0}?", GST));
        this.addEntry(COST, new PriceFieldType(), "currentCost", "The amount each purchased stock item costs.");
        this.addEntry(DISPLAY_MEASURE, new ObjectRefFieldType(MeasureUnitContainer.class, false, false, false, null), "displayMeasureUnitContainer", "The measure unit used to describe the stock on screen.");
        this.addEntry(QUANTITY, new QuantityFieldType(1.0E-4, 9999999.0, 1.0), "purchaseQty", "The quantity of stock that is added to the stock-on-hand for each stock item received.");
        this.addEntry(OUTER_CONTAINER, new ObjectRefFieldType(MeasureContainer.class, false, false, true, false), "outerContainer", "The name of the outer unit");
        this.addEntry(OUTER_QUANTITY, new DoubleFieldType(1.0, 9999999.0, 1.0), "outerQuantity", "Quantity multiplier for the outer unit.");
        this.addEntry(STOCK_GROUP, new ObjectRefFieldType(StockGroup.class, false, false, false, null), "stockGroup", "The stock group that the stock item belongs to.");
        this.addReadOnlyEntry(QUANTITY_ON_HAND, new QuantityFieldType(), "totalStockOnHand", "The current estimated quantity of stock on hand.");
        this.addEntry(INGREDIENT_MEASURE, new ObjectRefFieldType(MeasureUnit.class, false, false, false, null), "ingredientMeasureUnit", "The units used to measure ingredients for the stock.");
        this.addEntry(YIELD_AS_QUANTITY, new QuantityFieldType(), "yieldAsQuantity", "The units used to measure yield .");
        this.setObjectTextProp("label");
        this.addEntry(BARCODES, new ArrayFieldType(new StringFieldType("", false)), "barcodes", "The barcodes associated with this stock item.");
        this.addEntry(STOCKABLE_AREAS, new ArrayFieldType(new ObjectRefFieldType(StockArea.class)), "stockableAreas", "Stock areas that this stock item may be stocked in.");
        this.setEditPanelClass(StockItemEditorPanel.class);
    }
}

