/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.types.DateTimeFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.QuantityFieldType;
import officemate.adminkit.types.StringFieldType;
import officemate.screens.maintainstock.transfer.StockTransferEditorPanel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.StockTransfer;
import ordermate.database.users.User;

public class StockTransferTemplate
extends ObjectTemplate {
    public static final String USER = "User";
    public static final String STOCK_ITEM = "Stock Item";
    public static final String QUANTITY = "Quantity";
    public static final String TRANSFER_FROM = "Transfer From";
    public static final String TRANSFER_TO = "Transfer To";
    public static final String USAGE_DATE = "Usage Date";
    public static final String REASON = "Reason";

    public StockTransferTemplate() {
        super("Stock Transfer", StockTransfer.class);
        this.addEntry(USER, new ObjectRefFieldType(User.class, false, false, false, null), "user", "The user responsible for performing the transfer.");
        this.addEntry(STOCK_ITEM, new ObjectRefFieldType(StockItem.class, false, false, false, StockItemSearchPanel.class), "stockItem", "The stock item that had stock transferred.");
        this.addEntry(QUANTITY, new QuantityFieldType(0.0, 9999999.0, 1.0), "quantityUsed", "The quantity transferred.");
        this.addEntry(TRANSFER_FROM, new ObjectRefFieldType(StockArea.class, false, false, false, null), "stockArea", "The stock area this transfer was made from. This must be a different area from 'Transfer To'.");
        this.addEntry(TRANSFER_TO, new ObjectRefFieldType(StockArea.class, false, false, false, null), "stockAreaTransferTo", "The stock area this transfer was made to. This must be a different area from 'Transfer From'.");
        this.addEntry(USAGE_DATE, new DateTimeFieldType(), "usageDate", "The date and time the stock was transferred.");
        this.addEntry(REASON, new StringFieldType(), "reason", "The reason for the stock transfer.");
        this.setEditPanelClass(StockTransferEditorPanel.class);
    }
}

