/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.templates;

import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PasswordFieldType;
import officemate.adminkit.types.StringFieldType;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;

public class UserTemplate
extends ObjectTemplate {
    public static final String FIRST_NAME = "First name";
    public static final String LAST_NAME = "Last name";
    public static final String CARD_ID = "Card ID";
    public static final String PRIVILEGES = "Permission Group";
    public static final String PAYROLL_ID = "Payroll ID";
    public static final String PAY_RATE = "Pay rate";
    public static final String PIN = "PIN";
    public static final String PASSWORD = "Password";
    public static final String ACTIVE = "Active";
    public static final String DELIVERY_DRIVER = "Delivery Driver";

    public UserTemplate() {
        super("User", User.class);
        this.setObjectTextProp("label");
        this.addEntry(FIRST_NAME, new StringFieldType("", false), "firstName", "The user's first name");
        this.addEntry(LAST_NAME, new StringFieldType("", true), "lastName", "The user's last name");
        this.addEntry(CARD_ID, new StringFieldType(), "cardID", "The user's swipecard ID number");
        this.addEntry(PRIVILEGES, new ObjectRefFieldType(PermissionGroup.class), "permissionGroup", "The user's privilege level");
        this.addEntry(PAYROLL_ID, new StringFieldType(), "payrollID", "ID used for MYOB and Quickbooks payroll exporting");
        this.addEntry(PIN, new StringFieldType(), "pin", "The user's PIN for WaiterMate login");
        this.addEntry(PASSWORD, new PasswordFieldType(true), "password", "The user's password for OfficeMate and Stock Control login");
        this.addEntry(ACTIVE, new BoolFieldType(true), "active", "Whether the user is currently activated or not");
        this.addEntry(DELIVERY_DRIVER, new BoolFieldType(true), "driver", "Whether or not the user is a delivery driver");
    }
}

